/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.model.loading;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.impl.client.model.loading.BakerImplHooks;
import net.fabricmc.fabric.impl.client.model.loading.BlockStatesLoaderHooks;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoaderHooks;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingConstants;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingEventDispatcher;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingPluginManager;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_324;
import net.minecraft.class_3665;
import net.minecraft.class_3695;
import net.minecraft.class_4730;
import net.minecraft.class_7775;
import net.minecraft.class_793;
import net.minecraft.class_9824;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Coerce;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1088.class})
abstract class ModelLoaderMixin
implements ModelLoaderHooks {
    @Final
    @Shadow
    private Set<class_2960> field_5390;
    @Final
    @Shadow
    private Map<class_2960, class_1100> field_5376;
    @Shadow
    @Final
    private Map<class_1091, class_1100> field_5394;
    @Shadow
    @Final
    private class_1100 field_52275;
    @Unique
    private ModelLoadingEventDispatcher fabric_eventDispatcher;
    @Unique
    private final ObjectLinkedOpenHashSet<class_2960> modelLoadingStack = new ObjectLinkedOpenHashSet();

    ModelLoaderMixin() {
    }

    @Shadow
    abstract class_1100 method_4726(class_2960 var1);

    @Shadow
    abstract void method_61074(class_1091 var1, class_1100 var2);

    @Shadow
    abstract class_793 method_4718(class_2960 var1);

    @Inject(method={"<init>"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/model/BlockStatesLoader;load()V")})
    private void afterMissingModelInit(class_324 blockColors, class_3695 profiler, Map<class_2960, class_793> jsonUnbakedModels, Map<class_2960, List<class_9824.class_7777>> blockStates, CallbackInfo info, @Local class_9824 blockStatesLoader) {
        if (this.field_52275 == null || !this.field_5394.containsKey(class_1088.field_52276)) {
            throw new AssertionError((Object)"Missing model not initialized. This is likely a Fabric API porting bug.");
        }
        this.field_5376.put(class_1088.field_5374, this.field_52275);
        profiler.method_15405("fabric_plugins_init");
        this.fabric_eventDispatcher = new ModelLoadingEventDispatcher((class_1088)this, ModelLoadingPluginManager.CURRENT_PLUGINS.get());
        this.fabric_eventDispatcher.addExtraModels(this::addExtraModel);
        ((BlockStatesLoaderHooks)blockStatesLoader).fabric_setLoadingOverride(this.fabric_eventDispatcher::loadBlockStateModels);
    }

    @Unique
    private void addExtraModel(class_2960 id) {
        class_1091 modelId = ModelLoadingConstants.toResourceModelId(id);
        class_1100 unbakedModel = this.method_4726(id);
        this.method_61074(modelId, unbakedModel);
    }

    @Inject(method={"getOrLoadModel"}, at={@At(value="HEAD")}, cancellable=true)
    private void allowRecursiveLoading(class_2960 id, CallbackInfoReturnable<class_1100> cir) {
        if (!this.modelLoadingStack.isEmpty()) {
            if (this.field_5376.containsKey(id)) {
                cir.setReturnValue((Object)this.field_5376.get(id));
            } else {
                if (this.modelLoadingStack.contains((Object)id)) {
                    throw new IllegalStateException("Circular reference while loading model '" + String.valueOf(id) + "' (" + this.modelLoadingStack.stream().map(i -> String.valueOf(i) + "->").collect(Collectors.joining()) + String.valueOf(id) + ")");
                }
                class_1100 model = this.loadModel(id);
                this.field_5376.put(id, model);
                this.field_5390.addAll(model.method_4755());
                cir.setReturnValue((Object)model);
            }
        }
    }

    @Redirect(method={"getOrLoadModel"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/render/model/ModelLoader;loadModelFromJson(Lnet/minecraft/util/Identifier;)Lnet/minecraft/client/render/model/json/JsonUnbakedModel;"))
    private class_793 cancelLoadModelFromJson(class_1088 self, class_2960 id) {
        return null;
    }

    @ModifyVariable(method={"getOrLoadModel"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/render/model/ModelLoader;loadModelFromJson(Lnet/minecraft/util/Identifier;)Lnet/minecraft/client/render/model/json/JsonUnbakedModel;"))
    private class_1100 doLoadModel(class_1100 model, @Local(ordinal=1) class_2960 id) {
        return this.loadModel(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unique
    private class_1100 loadModel(class_2960 id) {
        this.modelLoadingStack.add((Object)id);
        try {
            class_1100 model = this.fabric_eventDispatcher.resolveModel(id);
            if (model == null) {
                model = this.method_4718(id);
            }
            class_1100 class_11002 = this.fabric_eventDispatcher.modifyModelOnLoad(model, id, null);
            return class_11002;
        }
        finally {
            this.modelLoadingStack.removeLast();
        }
    }

    @ModifyVariable(method={"add"}, at=@At(value="HEAD"), argsOnly=true)
    private class_1100 onAdd(class_1100 model, class_1091 id) {
        if (ModelLoadingConstants.isResourceModelId(id)) {
            return model;
        }
        return this.fabric_eventDispatcher.modifyModelOnLoad(model, null, id);
    }

    @WrapOperation(method={"method_61072(Lnet/minecraft/client/render/model/ModelLoader$SpriteGetter;Lnet/minecraft/client/util/ModelIdentifier;Lnet/minecraft/client/render/model/UnbakedModel;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/render/model/ModelLoader$BakerImpl;bake(Lnet/minecraft/client/render/model/UnbakedModel;Lnet/minecraft/client/render/model/ModelBakeSettings;)Lnet/minecraft/client/render/model/BakedModel;")})
    private class_1087 wrapSingleOuterBake(@Coerce class_7775 baker, class_1100 unbakedModel, class_3665 settings, Operation<class_1087> operation, class_1088.class_9826 spriteGetter, class_1091 id) {
        if (ModelLoadingConstants.isResourceModelId(id) || id.equals((Object)class_1088.field_52276)) {
            return baker.method_45873(id.comp_2875(), settings);
        }
        Function<class_4730, class_1058> textureGetter = ((BakerImplHooks)baker).fabric_getTextureGetter();
        unbakedModel = this.fabric_eventDispatcher.modifyModelBeforeBake(unbakedModel, null, id, textureGetter, settings, baker);
        class_1087 model = (class_1087)operation.call(new Object[]{baker, unbakedModel, settings});
        return this.fabric_eventDispatcher.modifyModelAfterBake(model, null, id, unbakedModel, textureGetter, settings, baker);
    }

    @Override
    public ModelLoadingEventDispatcher fabric_getDispatcher() {
        return this.fabric_eventDispatcher;
    }

    @Override
    public class_1100 fabric_getMissingModel() {
        return this.field_52275;
    }

    @Override
    public class_1100 fabric_getOrLoadModel(class_2960 id) {
        return this.method_4726(id);
    }

    @Override
    public void fabric_add(class_1091 id, class_1100 model) {
        this.method_61074(id, model);
    }
}

