/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.model.loading;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.CustomUnbakedBlockStateModel;
import net.minecraft.class_1087;
import net.minecraft.class_10893;
import net.minecraft.class_1097;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_6010;
import net.minecraft.class_6012;
import net.minecraft.class_813;

@Environment(value=EnvType.CLIENT)
public class CustomUnbakedBlockStateModelRegistry {
    private static final String TYPE_KEY = "fabric:type";
    private static final class_5699.class_10388<class_2960, MapCodec<? extends CustomUnbakedBlockStateModel>> ID_MAPPER = new class_5699.class_10388();
    private static final MapCodec<CustomUnbakedBlockStateModel> CUSTOM_MODEL_MAP_CODEC = ID_MAPPER.method_65323(class_2960.field_25139).dispatchMap("fabric:type", CustomUnbakedBlockStateModel::codec, codec -> codec);
    private static final MapCodec<class_10893.class_10894> SIMPLE_MODEL_MAP_CODEC = class_813.field_57947.xmap(class_10893.class_10894::new, class_10893.class_10894::comp_3815);
    private static final MapCodec<Either<CustomUnbakedBlockStateModel, class_10893.class_10894>> VARIANT_MAP_CODEC = new KeyExistsCodec<CustomUnbakedBlockStateModel, class_10893.class_10894>("fabric:type", CUSTOM_MODEL_MAP_CODEC, SIMPLE_MODEL_MAP_CODEC);
    private static final Codec<Either<CustomUnbakedBlockStateModel, class_10893.class_10894>> VARIANT_CODEC = VARIANT_MAP_CODEC.codec();
    private static final Codec<class_6010<Either<CustomUnbakedBlockStateModel, class_10893.class_10894>>> WEIGHTED_VARIANT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)VARIANT_MAP_CODEC.forGetter(class_6010::comp_2542), (App)class_5699.field_33442.optionalFieldOf("weight", (Object)1).forGetter(class_6010::comp_2543)).apply((Applicative)instance, class_6010::new));
    public static final Codec<class_1097.class_10898> WEIGHTED_MODEL_CODEC = class_5699.method_36973((Codec)WEIGHTED_VARIANT_CODEC.listOf()).flatComapMap(weightedVariants -> new class_1097.class_10898(class_6012.method_34988((List)Lists.transform((List)weightedVariants, weighted -> weighted.method_68255(either -> (class_1087.class_10892)either.map(Function.identity(), Function.identity()))))), model -> {
        List entries = model.comp_3816().method_34994();
        ArrayList<class_6010> weightedVariants = new ArrayList<class_6010>(entries.size());
        block4: for (class_6010 weighted : entries) {
            class_1087.class_10892 selector0$temp;
            Objects.requireNonNull((class_1087.class_10892)weighted.comp_2542());
            int index$1 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CustomUnbakedBlockStateModel.class, class_10893.class_10894.class}, (Object)selector0$temp, index$1)) {
                case 0: {
                    CustomUnbakedBlockStateModel custom = (CustomUnbakedBlockStateModel)selector0$temp;
                    weightedVariants.add(new class_6010((Object)Either.left((Object)custom), weighted.comp_2543()));
                    continue block4;
                }
                case 1: {
                    class_10893.class_10894 simple = (class_10893.class_10894)selector0$temp;
                    weightedVariants.add(new class_6010((Object)Either.right((Object)simple), weighted.comp_2543()));
                    continue block4;
                }
            }
            return DataResult.error(() -> "Only custom models or single variants are supported");
        }
        return DataResult.success(weightedVariants);
    });
    public static final Codec<class_1087.class_10892> MODEL_CODEC = Codec.either(WEIGHTED_MODEL_CODEC, VARIANT_CODEC).flatComapMap(either -> (class_1087.class_10892)either.map(Function.identity(), right -> (class_1087.class_10892)right.map(Function.identity(), Function.identity())), model -> {
        Objects.requireNonNull(model);
        class_1087.class_10892 class_108922 = model;
        Objects.requireNonNull(class_108922);
        class_1087.class_10892 selector0$temp = class_108922;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CustomUnbakedBlockStateModel.class, class_10893.class_10894.class, class_1097.class_10898.class}, (Object)selector0$temp, index$1)) {
            case 0 -> {
                CustomUnbakedBlockStateModel custom = (CustomUnbakedBlockStateModel)selector0$temp;
                yield DataResult.success((Object)Either.right((Object)Either.left((Object)custom)));
            }
            case 1 -> {
                class_10893.class_10894 simple = (class_10893.class_10894)selector0$temp;
                yield DataResult.success((Object)Either.right((Object)Either.right((Object)simple)));
            }
            case 2 -> {
                class_1097.class_10898 weighted = (class_1097.class_10898)selector0$temp;
                yield DataResult.success((Object)Either.left((Object)weighted));
            }
            default -> DataResult.error(() -> "Only a custom model or a single variant or a list of variants are supported");
        };
    });

    public static void register(class_2960 id, MapCodec<? extends CustomUnbakedBlockStateModel> codec) {
        ID_MAPPER.method_65325((Object)id, codec);
    }

    @Environment(value=EnvType.CLIENT)
    private static class KeyExistsCodec<E, N>
    extends MapCodec<Either<E, N>> {
        private final String key;
        private final MapCodec<E> exists;
        private final MapCodec<N> notExists;

        KeyExistsCodec(String key, MapCodec<E> exists, MapCodec<N> notExists) {
            this.key = key;
            this.exists = exists;
            this.notExists = notExists;
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return Stream.concat(this.exists.keys(ops), this.notExists.keys(ops));
        }

        public <T> DataResult<Either<E, N>> decode(DynamicOps<T> ops, MapLike<T> input) {
            if (input.get(this.key) != null) {
                return this.exists.decode(ops, input).map(Either::left);
            }
            return this.notExists.decode(ops, input).map(Either::right);
        }

        public <T> RecordBuilder<T> encode(Either<E, N> input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return (RecordBuilder)input.map(left -> this.exists.encode(left, ops, prefix), right -> this.notExists.encode(right, ops, prefix));
        }

        public String toString() {
            return "KeyExistsCodec[" + this.key + " " + String.valueOf(this.exists) + " " + String.valueOf(this.notExists) + "]";
        }
    }
}

