/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.model.loading;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.io.Reader;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ExtraModelKey;
import net.fabricmc.fabric.api.client.model.loading.v1.FabricBakedModelManager;
import net.fabricmc.fabric.api.client.model.loading.v1.UnbakedModelDeserializer;
import net.fabricmc.fabric.impl.client.model.loading.BakedModelsHooks;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingEventDispatcher;
import net.fabricmc.fabric.impl.client.model.loading.ModelLoadingPluginManager;
import net.minecraft.class_10097;
import net.minecraft.class_10521;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3302;
import net.minecraft.class_793;
import net.minecraft.class_9824;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1092.class})
abstract class BakedModelManagerMixin
implements FabricBakedModelManager {
    @Unique
    private volatile @Nullable CompletableFuture<ModelLoadingEventDispatcher> eventDispatcherFuture;
    @Unique
    private @Nullable Map<ExtraModelKey<?>, ?> extraModels;

    BakedModelManagerMixin() {
    }

    @Override
    public <T> @Nullable T getModel(ExtraModelKey<T> key) {
        return this.extraModels == null ? null : (T)this.extraModels.get(key);
    }

    @Inject(method={"method_25931(Lnet/minecraft/class_3302$class_11558;Ljava/util/concurrent/Executor;Lnet/minecraft/class_3302$class_4045;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="HEAD")})
    private void onHeadReload(class_3302.class_11558 sharedState, Executor prepareExecutor, class_3302.class_4045 synchronizer, Executor applyExecutor, CallbackInfoReturnable<CompletableFuture<Void>> cir) {
        this.eventDispatcherFuture = ModelLoadingPluginManager.preparePlugins(sharedState, prepareExecutor).thenApplyAsync(ModelLoadingEventDispatcher::new, prepareExecutor);
    }

    @ModifyReturnValue(method={"method_25931(Lnet/minecraft/class_3302$class_11558;Ljava/util/concurrent/Executor;Lnet/minecraft/class_3302$class_4045;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="RETURN")})
    private CompletableFuture<Void> resetEventDispatcherFuture(CompletableFuture<Void> future) {
        return future.thenApplyAsync(v -> {
            this.eventDispatcherFuture = null;
            return v;
        });
    }

    @ModifyExpressionValue(method={"method_25931(Lnet/minecraft/class_3302$class_11558;Ljava/util/concurrent/Executor;Lnet/minecraft/class_3302$class_4045;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1092;method_45881(Lnet/minecraft/class_3300;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")})
    private CompletableFuture<Map<class_2960, class_1100>> hookModels(CompletableFuture<Map<class_2960, class_1100>> modelsFuture) {
        return modelsFuture.thenCombine(this.eventDispatcherFuture, (models, eventDispatcher) -> eventDispatcher.modifyModelsOnLoad((Map<class_2960, class_1100>)models));
    }

    @ModifyExpressionValue(method={"method_25931(Lnet/minecraft/class_3302$class_11558;Ljava/util/concurrent/Executor;Lnet/minecraft/class_3302$class_4045;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_9824;method_65718(Lnet/minecraft/class_3300;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;")})
    private CompletableFuture<class_9824.class_10095> hookBlockStateModels(CompletableFuture<class_9824.class_10095> modelsFuture) {
        return modelsFuture.thenCombine(this.eventDispatcherFuture, (models, eventDispatcher) -> eventDispatcher.modifyBlockModelsOnLoad((class_9824.class_10095)models));
    }

    @ModifyArg(method={"method_25931(Lnet/minecraft/class_3302$class_11558;Ljava/util/concurrent/Executor;Lnet/minecraft/class_3302$class_4045;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;thenApplyAsync(Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;", ordinal=1), index=0)
    private Function<Void, ?> hookModelCollect(Function<Void, CompletableFuture<?>> function) {
        return this.withModelDispatcher(function);
    }

    @ModifyArg(method={"method_25931(Lnet/minecraft/class_3302$class_11558;Ljava/util/concurrent/Executor;Lnet/minecraft/class_3302$class_4045;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;"}, at=@At(value="INVOKE", target="Ljava/util/concurrent/CompletableFuture;thenComposeAsync(Ljava/util/function/Function;Ljava/util/concurrent/Executor;)Ljava/util/concurrent/CompletableFuture;", ordinal=0), index=0)
    private Function<Void, CompletableFuture<?>> hookModelBaking(Function<Void, CompletableFuture<?>> function) {
        return this.withModelDispatcher(function);
    }

    @Unique
    private <T, R> Function<T, R> withModelDispatcher(Function<T, R> function) {
        CompletableFuture<ModelLoadingEventDispatcher> future = this.eventDispatcherFuture;
        if (future == null) {
            return function;
        }
        return x -> {
            ModelLoadingEventDispatcher.CURRENT.set((ModelLoadingEventDispatcher)future.join());
            try {
                Object r = function.apply(x);
                return r;
            }
            finally {
                ModelLoadingEventDispatcher.CURRENT.remove();
            }
        };
    }

    @Inject(method={"method_62657(Ljava/util/Map;Lnet/minecraft/class_9824$class_10095;Lnet/minecraft/class_10521$class_10522;)Lnet/minecraft/class_1092$class_10816;"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_10097;method_68028()Ljava/util/Map;")})
    private static void resolveExtraModels(Map<class_2960, class_1100> modelMap, class_9824.class_10095 stateDefinition, class_10521.class_10522 result, CallbackInfoReturnable<?> cir, @Local class_10097 collector) {
        ModelLoadingEventDispatcher eventDispatcher = ModelLoadingEventDispatcher.CURRENT.get();
        if (eventDispatcher != null) {
            eventDispatcher.getExtraModels().values().forEach(arg_0 -> ((class_10097)collector).method_65744(arg_0));
        }
    }

    @Inject(method={"method_18179(Lnet/minecraft/class_1092$class_7779;)V"}, at={@At(value="RETURN")})
    private void onReturnUpload(CallbackInfo ci, @Local class_1088.class_10524 bakedModels) {
        this.extraModels = ((BakedModelsHooks)bakedModels).fabric_getExtraModels();
    }

    @Redirect(method={"method_65750(Ljava/util/Map$Entry;)Lcom/mojang/datafixers/util/Pair;"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_793;method_3437(Ljava/io/Reader;)Lnet/minecraft/class_793;"))
    private static class_793 cancelVanillaDeserialize(Reader reader) {
        return null;
    }

    @ModifyArg(method={"method_65750(Ljava/util/Map$Entry;)Lcom/mojang/datafixers/util/Pair;"}, at=@At(value="INVOKE", target="Lcom/mojang/datafixers/util/Pair;of(Ljava/lang/Object;Ljava/lang/Object;)Lcom/mojang/datafixers/util/Pair;"), index=1)
    private static Object actuallyDeserializeModel(Object originalModel, @Local Reader reader) {
        return UnbakedModelDeserializer.deserialize(reader);
    }
}

