/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.server;

import io.netty.channel.ChannelFutureListener;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.S2CConfigurationChannelEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.impl.networking.AbstractChanneledNetworkAddon;
import net.fabricmc.fabric.impl.networking.ChannelInfoHolder;
import net.fabricmc.fabric.impl.networking.NetworkingImpl;
import net.fabricmc.fabric.impl.networking.RegistrationPayload;
import net.fabricmc.fabric.impl.networking.server.ServerNetworkingImpl;
import net.fabricmc.fabric.mixin.networking.accessor.ServerCommonNetworkHandlerAccessor;
import net.minecraft.class_2539;
import net.minecraft.class_2596;
import net.minecraft.class_2960;
import net.minecraft.class_6373;
import net.minecraft.class_8610;
import net.minecraft.class_8709;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public final class ServerConfigurationNetworkAddon
extends AbstractChanneledNetworkAddon<ServerConfigurationNetworking.ConfigurationPacketHandler<?>> {
    private final class_8610 handler;
    private final MinecraftServer server;
    private final ServerConfigurationNetworking.Context context;
    private RegisterState registerState = RegisterState.NOT_SENT;
    @Nullable
    private String clientBrand = null;
    private boolean isReconfiguring = false;

    public ServerConfigurationNetworkAddon(class_8610 handler, MinecraftServer server) {
        super(ServerNetworkingImpl.CONFIGURATION, ((ServerCommonNetworkHandlerAccessor)handler).getConnection(), "ServerConfigurationNetworkAddon for " + handler.method_52404().name());
        this.handler = handler;
        this.server = server;
        this.context = new ContextImpl(server, handler, this);
        this.registerPendingChannels((ChannelInfoHolder)this.connection, class_2539.field_45671);
    }

    @Override
    public boolean handle(class_8710 payload) {
        if (payload instanceof class_8709) {
            class_8709 brandCustomPayload = (class_8709)payload;
            this.clientBrand = brandCustomPayload.comp_1677();
            return false;
        }
        return super.handle(payload);
    }

    @Override
    protected void invokeInitEvent() {
    }

    public void preConfiguration() {
        ((ServerConfigurationConnectionEvents.Configure)ServerConfigurationConnectionEvents.BEFORE_CONFIGURE.invoker()).onSendConfiguration(this.handler, this.server);
    }

    public void configuration() {
        ((ServerConfigurationConnectionEvents.Configure)ServerConfigurationConnectionEvents.CONFIGURE.invoker()).onSendConfiguration(this.handler, this.server);
    }

    public boolean startConfiguration() {
        if (this.registerState == RegisterState.NOT_SENT) {
            this.sendInitialChannelRegistrationPacket();
            this.sendPacket((class_2596<?>)new class_6373(16430876));
            this.registerState = RegisterState.SENT;
            return true;
        }
        if (this.registerState != RegisterState.RECEIVED && this.registerState != RegisterState.NOT_RECEIVED) {
            throw new IllegalStateException();
        }
        return false;
    }

    @Override
    protected void receiveRegistration(boolean register, RegistrationPayload resolvable) {
        super.receiveRegistration(register, resolvable);
        if (register && this.registerState == RegisterState.SENT) {
            this.registerState = RegisterState.RECEIVED;
            this.handler.method_52409();
        }
    }

    public void onPong(int parameter) {
        if (this.registerState == RegisterState.SENT) {
            this.registerState = RegisterState.NOT_RECEIVED;
            this.handler.method_52409();
        }
    }

    @Override
    protected void receive(ServerConfigurationNetworking.ConfigurationPacketHandler<?> handler, class_8710 payload) {
        handler.receive(payload, this.context);
    }

    @Override
    protected void schedule(Runnable task) {
        this.server.execute(task);
    }

    @Override
    public class_2596<?> createPacket(class_8710 packet) {
        return ServerConfigurationNetworking.createS2CPacket(packet);
    }

    @Override
    protected void invokeRegisterEvent(List<class_2960> ids) {
        ((S2CConfigurationChannelEvents.Register)S2CConfigurationChannelEvents.REGISTER.invoker()).onChannelRegister(this.handler, this, this.server, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<class_2960> ids) {
        ((S2CConfigurationChannelEvents.Unregister)S2CConfigurationChannelEvents.UNREGISTER.invoker()).onChannelUnregister(this.handler, this, this.server, ids);
    }

    @Override
    protected void handleRegistration(class_2960 channelName) {
        RegistrationPayload registrationPayload;
        if (this.registerState != RegisterState.NOT_SENT && (registrationPayload = this.createRegistrationPayload(RegistrationPayload.REGISTER, Collections.singleton(channelName))) != null) {
            this.sendPacket(registrationPayload);
        }
    }

    @Override
    protected void handleUnregistration(class_2960 channelName) {
        RegistrationPayload registrationPayload;
        if (this.registerState != RegisterState.NOT_SENT && (registrationPayload = this.createRegistrationPayload(RegistrationPayload.UNREGISTER, Collections.singleton(channelName))) != null) {
            this.sendPacket(registrationPayload);
        }
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ServerConfigurationConnectionEvents.Disconnect)ServerConfigurationConnectionEvents.DISCONNECT.invoker()).onConfigureDisconnect(this.handler, this.server);
    }

    @Override
    protected boolean isReservedChannel(class_2960 channelName) {
        return NetworkingImpl.isReservedCommonChannel(channelName);
    }

    @Override
    public void sendPacket(class_2596<?> packet, ChannelFutureListener callback) {
        this.handler.method_52391(packet, callback);
    }

    @Nullable
    public String getClientBrand() {
        return this.clientBrand;
    }

    public boolean isReconfiguring() {
        return this.isReconfiguring;
    }

    public void setReconfiguring() {
        this.isReconfiguring = true;
    }

    public ChannelInfoHolder getChannelInfoHolder() {
        return (ChannelInfoHolder)((ServerCommonNetworkHandlerAccessor)this.handler).getConnection();
    }

    private static enum RegisterState {
        NOT_SENT,
        SENT,
        RECEIVED,
        NOT_RECEIVED;

    }

    private record ContextImpl(MinecraftServer server, class_8610 networkHandler, PacketSender responseSender) implements ServerConfigurationNetworking.Context
    {
        private ContextImpl {
            Objects.requireNonNull(server, "server");
            Objects.requireNonNull(networkHandler, "networkHandler");
            Objects.requireNonNull(responseSender, "responseSender");
        }
    }
}

