/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.networking;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.networking.splitter.PassthroughPacket;
import net.minecraft.class_2545;
import net.minecraft.class_2596;

// Lowered the default priority, as this should happen before other mods.
@Mixin(value = class_2545.class, priority = 500)
public class EncoderHandlerMixin {
	@Inject(method = "encode(Lio/netty/channel/ChannelHandlerContext;Lnet/minecraft/network/packet/Packet;Lio/netty/buffer/ByteBuf;)V", at = @At("HEAD"), cancellable = true)
	private void handlePassthroughPacket(ChannelHandlerContext channelHandlerContext, class_2596<?> packet, ByteBuf byteBuf, CallbackInfo ci) {
		if (packet instanceof PassthroughPacket passthroughPacket) {
			byteBuf.writeBytes(passthroughPacket.buf());
			ci.cancel();
		}
	}
}
