/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.networking;

import com.llamalad7.mixinextras.sugar.Local;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.EncoderException;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_8710;
import net.minecraft.class_9136;
import net.minecraft.class_9139;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_9136.class)
public abstract class IdDispatchCodecMixin<B extends ByteBuf, V, T> implements class_9139<B, V> {
	// Add the custom payload id to the error message
	@Inject(method = "encode(Lio/netty/buffer/ByteBuf;Ljava/lang/Object;)V", at = @At(value = "NEW", target = "(Ljava/lang/String;Ljava/lang/Throwable;)Lio/netty/handler/codec/EncoderException;"))
	public void encode(B byteBuf, V packet, CallbackInfo ci, @Local(ordinal = 1) T packetId, @Local Exception e) {
		class_8710 payload = null;

		if (packet instanceof class_2817 customPayloadC2SPacket) {
			payload = customPayloadC2SPacket.comp_1647();
		} else if (packet instanceof class_2658 customPayloadS2CPacket) {
			payload = customPayloadS2CPacket.comp_1646();
		}

		if (payload != null && payload.method_56479() != null) {
			throw new EncoderException("Failed to encode packet '%s' (%s)".formatted(packetId, payload.method_56479().comp_2242().toString()), e);
		}
	}
}
