/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.networking;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.minecraft.class_2817;
import net.minecraft.class_2987;
import net.minecraft.class_6374;
import net.minecraft.class_8609;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import net.fabricmc.fabric.impl.networking.NetworkHandlerExtensions;
import net.fabricmc.fabric.impl.networking.server.ServerConfigurationNetworkAddon;

@Mixin(class_8609.class)
public abstract class ServerCommonPacketListenerImplMixin implements NetworkHandlerExtensions {
	@Shadow
	@Final
	protected MinecraftServer server;

	@Inject(method = "handleCustomPayload", at = @At("HEAD"), cancellable = true)
	private void handleCustomPayloadReceivedAsync(class_2817 packet, CallbackInfo ci) {
		final class_8710 payload = packet.comp_1647();

		try {
			boolean handled;

			if (getAddon() instanceof ServerConfigurationNetworkAddon addon) {
				handled = addon.handle(payload);
			} else {
				// Play should be handled in ServerGamePacketListenerImplMixin
				throw new IllegalStateException("Unknown addon");
			}

			if (handled) {
				ci.cancel();
			}
		} catch (class_2987 e) {
			this.server.method_74432().method_74448((class_8609) (Object) this, packet);
			ci.cancel();
		}
	}

	@Inject(method = "handlePong", at = @At("HEAD"))
	private void onPlayPong(class_6374 packet, CallbackInfo ci) {
		if (getAddon() instanceof ServerConfigurationNetworkAddon addon) {
			addon.onPong(packet.method_36960());
		}
	}
}
