/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking;

import io.netty.buffer.ByteBufUtil;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.network.ConnectionProtocol;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;

public class PayloadTypeRegistryImpl<B extends FriendlyByteBuf>
implements PayloadTypeRegistry<B> {
    public static final PayloadTypeRegistryImpl<FriendlyByteBuf> SERVERBOUND_CONFIGURATION = new PayloadTypeRegistryImpl(ConnectionProtocol.CONFIGURATION, PacketFlow.SERVERBOUND);
    public static final PayloadTypeRegistryImpl<FriendlyByteBuf> CLIENTBOUND_CONFIGURATION = new PayloadTypeRegistryImpl(ConnectionProtocol.CONFIGURATION, PacketFlow.CLIENTBOUND);
    public static final PayloadTypeRegistryImpl<RegistryFriendlyByteBuf> SERVERBOUND_PLAY = new PayloadTypeRegistryImpl(ConnectionProtocol.PLAY, PacketFlow.SERVERBOUND);
    public static final PayloadTypeRegistryImpl<RegistryFriendlyByteBuf> CLIENTBOUND_PLAY = new PayloadTypeRegistryImpl(ConnectionProtocol.PLAY, PacketFlow.CLIENTBOUND);
    private final Map<Identifier, CustomPacketPayload.TypeAndCodec<B, ? extends CustomPacketPayload>> packetTypes = new HashMap<Identifier, CustomPacketPayload.TypeAndCodec<B, ? extends CustomPacketPayload>>();
    private final Object2IntMap<Identifier> maxPacketSize = new Object2IntOpenHashMap();
    private final ConnectionProtocol protocol;
    private final PacketFlow flow;
    private final int minimalSplittableSize;

    private PayloadTypeRegistryImpl(ConnectionProtocol protocol, PacketFlow flow) {
        this.protocol = protocol;
        this.flow = flow;
        this.minimalSplittableSize = flow == PacketFlow.CLIENTBOUND ? 0x100000 : Short.MAX_VALUE;
    }

    public static @Nullable PayloadTypeRegistryImpl<?> get(ProtocolInfo<?> state) {
        return switch (state.id()) {
            case ConnectionProtocol.CONFIGURATION -> {
                if (state.flow() == PacketFlow.CLIENTBOUND) {
                    yield CLIENTBOUND_CONFIGURATION;
                }
                yield SERVERBOUND_CONFIGURATION;
            }
            case ConnectionProtocol.PLAY -> {
                if (state.flow() == PacketFlow.CLIENTBOUND) {
                    yield CLIENTBOUND_PLAY;
                }
                yield SERVERBOUND_PLAY;
            }
            default -> null;
        };
    }

    @Override
    public <T extends CustomPacketPayload> CustomPacketPayload.TypeAndCodec<? super B, T> register(CustomPacketPayload.Type<T> type, StreamCodec<? super B, T> codec) {
        Objects.requireNonNull(type, "id");
        Objects.requireNonNull(codec, "codec");
        CustomPacketPayload.TypeAndCodec payloadType = new CustomPacketPayload.TypeAndCodec(type, codec.cast());
        if (this.packetTypes.containsKey(type.id())) {
            throw new IllegalArgumentException("Packet type " + String.valueOf(type) + " is already registered!");
        }
        this.packetTypes.put(type.id(), payloadType);
        return payloadType;
    }

    @Override
    public <T extends CustomPacketPayload> CustomPacketPayload.TypeAndCodec<? super B, T> registerLarge(CustomPacketPayload.Type<T> type, StreamCodec<? super B, T> codec, int maxPayloadSize) {
        if (maxPayloadSize < 0) {
            throw new IllegalArgumentException("Provided maxPayloadSize needs to be positive!");
        }
        CustomPacketPayload.TypeAndCodec<? super B, T> typeAndCodec = this.register(type, codec);
        int identifierSize = ByteBufUtil.utf8MaxBytes((CharSequence)type.id().toString());
        int maxPacketSize = maxPayloadSize + VarInt.getByteSize((int)identifierSize) + identifierSize + 10;
        if (maxPacketSize < 0) {
            maxPacketSize = Integer.MAX_VALUE;
        }
        if (maxPacketSize > this.minimalSplittableSize) {
            this.maxPacketSize.put((Object)type.id(), maxPacketSize);
        }
        return typeAndCodec;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable CustomPacketPayload.TypeAndCodec<B, ? extends CustomPacketPayload> get(Identifier id) {
        return this.packetTypes.get(id);
    }

    public <T extends CustomPacketPayload> // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable CustomPacketPayload.TypeAndCodec<B, T> get(CustomPacketPayload.Type<T> id) {
        return this.packetTypes.get(id.id());
    }

    public int getMaxPacketSize(Identifier id) {
        return this.maxPacketSize.getOrDefault((Object)id, -1);
    }

    public ConnectionProtocol getProtocol() {
        return this.protocol;
    }

    public PacketFlow getFlow() {
        return this.flow;
    }
}

