/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.networking;

import java.util.Objects;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.network.PacketConsumer;
import net.fabricmc.fabric.api.network.PacketContext;
import net.fabricmc.fabric.api.network.PacketRegistry;
import net.fabricmc.fabric.api.network.ServerSidePacketRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1255;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ServerSidePacketRegistryImpl implements ServerSidePacketRegistry, PacketRegistry {
	@Override
	public boolean canPlayerReceive(class_1657 player, class_2960 id) {
		if (player instanceof class_3222) {
			return ServerPlayNetworking.canSend((class_3222) player, id);
		}

		return false;
	}

	@Override
	public void sendToPlayer(class_1657 player, class_2596<?> packet, GenericFutureListener<? extends Future<? super Void>> completionListener) {
		if (player instanceof class_3222) {
			((class_3222) player).field_13987.method_14369(packet, completionListener);
			return;
		}

		throw new RuntimeException("Can only send to ServerPlayerEntities!");
	}

	@Override
	public class_2596<?> toPacket(class_2960 id, class_2540 buf) {
		return new class_2658(id, buf);
	}

	@Override
	public void register(class_2960 id, PacketConsumer consumer) {
		Objects.requireNonNull(consumer, "PacketConsumer cannot be null");

		ServerPlayNetworking.registerGlobalReceiver(id, (server, player, handler, buf, sender) -> {
			consumer.accept(new PacketContext() {
				@Override
				public EnvType getPacketEnvironment() {
					return EnvType.SERVER;
				}

				@Override
				public class_1657 getPlayer() {
					return player;
				}

				@Override
				public class_1255<?> getTaskQueue() {
					return server;
				}
			}, buf);
		});
	}

	@Override
	public void unregister(class_2960 id) {
		ServerPlayNetworking.unregisterGlobalReceiver(id);
	}
}
