/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.object.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TradeOfferInternals {
	private static final Logger LOGGER = LogManager.getLogger("fabric-object-builder-api-v1");

	private TradeOfferInternals() {
	}

	// synchronized guards against concurrent modifications - Vanilla does not mutate the underlying arrays (as of 1.16),
	// so reads will be fine without locking.
	public static synchronized void registerVillagerOffers(class_3852 profession, int level, Consumer<List<class_3853.class_1652>> factory) {
		Objects.requireNonNull(profession, "VillagerProfession may not be null.");
		registerOffers(class_3853.field_17067.computeIfAbsent(profession, key -> new Int2ObjectOpenHashMap<>()), level, factory);
	}

	public static synchronized void registerWanderingTraderOffers(int level, Consumer<List<class_3853.class_1652>> factory) {
		registerOffers(class_3853.field_17724, level, factory);
	}

	// Shared code to register offers for both villagers and wandering traders.
	private static void registerOffers(Int2ObjectMap<class_3853.class_1652[]> leveledTradeMap, int level, Consumer<List<class_3853.class_1652>> factory) {
		final List<class_3853.class_1652> list = new ArrayList<>();
		factory.accept(list);

		final class_3853.class_1652[] originalEntries = leveledTradeMap.computeIfAbsent(level, key -> new class_3853.class_1652[0]);
		final class_3853.class_1652[] addedEntries = list.toArray(new class_3853.class_1652[0]);

		final class_3853.class_1652[] allEntries = ArrayUtils.addAll(originalEntries, addedEntries);
		leveledTradeMap.put(level, allEntries);
	}

	public static void printRefreshOffersWarning() {
		Throwable loggingThrowable = new Throwable();
		LOGGER.warn("TradeOfferHelper#refreshOffers does not do anything, yet it was called! Stack trace:", loggingThrowable);
	}
}
