/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.object.builder;

import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Invoker;
import com.google.common.collect.ImmutableSet;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_3414;
import net.minecraft.class_3852;
import net.minecraft.class_4158;

@Mixin(class_3852.class)
public interface VillagerProfessionAccessor {
	@Invoker("<init>")
	static class_3852 create(String id, class_4158 type, ImmutableSet<class_1792> gatherableItems, ImmutableSet<class_2248> secondaryJobSites, @Nullable class_3414 soundEvent) {
		throw new AssertionError("Untransformed accessor!");
	}
}
