/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.object.builder;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TradeOfferInternals {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-object-builder-api-v1");

    private TradeOfferInternals() {
    }

    private static void initVillagerTrades() {
        if (!(class_3853.field_45128 instanceof HashMap)) {
            HashMap<class_3852, Int2ObjectMap> map = new HashMap<class_3852, Int2ObjectMap>(class_3853.field_45128);
            for (Map.Entry trade : class_3853.field_17067.entrySet()) {
                if (map.containsKey(trade.getKey())) continue;
                map.put((class_3852)trade.getKey(), (Int2ObjectMap)trade.getValue());
            }
            class_3853.field_45128 = map;
        }
    }

    public static synchronized void registerVillagerOffers(class_3852 profession, int level, TradeOfferHelper.VillagerOffersAdder factory) {
        Objects.requireNonNull(profession, "VillagerProfession may not be null.");
        TradeOfferInternals.initVillagerTrades();
        TradeOfferInternals.registerOffers((Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_17067.computeIfAbsent(profession, key -> new Int2ObjectOpenHashMap()), level, trades -> factory.onRegister((List<class_3853.class_1652>)trades, false));
        TradeOfferInternals.registerOffers((Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_45128.computeIfAbsent(profession, key -> new Int2ObjectOpenHashMap()), level, trades -> factory.onRegister((List<class_3853.class_1652>)trades, true));
    }

    public static synchronized void registerWanderingTraderOffers(int level, Consumer<List<class_3853.class_1652>> factory) {
        TradeOfferInternals.registerOffers((Int2ObjectMap<class_3853.class_1652[]>)class_3853.field_17724, level, factory);
    }

    private static void registerOffers(Int2ObjectMap<class_3853.class_1652[]> leveledTradeMap, int level, Consumer<List<class_3853.class_1652>> factory) {
        ArrayList list = new ArrayList();
        factory.accept(list);
        Object[] originalEntries = (class_3853.class_1652[])leveledTradeMap.computeIfAbsent(level, key -> new class_3853.class_1652[0]);
        Object[] addedEntries = list.toArray(new class_3853.class_1652[0]);
        class_3853.class_1652[] allEntries = (class_3853.class_1652[])ArrayUtils.addAll((Object[])originalEntries, (Object[])addedEntries);
        leveledTradeMap.put(level, (Object)allEntries);
    }

    public static void printRefreshOffersWarning() {
        Throwable loggingThrowable = new Throwable();
        LOGGER.warn("TradeOfferHelper#refreshOffers does not do anything, yet it was called! Stack trace:", loggingThrowable);
    }

    public static class WanderingTraderOffersBuilderImpl
    implements TradeOfferHelper.WanderingTraderOffersBuilder {
        private static final Object2IntMap<class_2960> ID_TO_INDEX = (Object2IntMap)class_156.method_654((Object)new Object2IntOpenHashMap(), idToIndex -> {
            idToIndex.put((Object)BUY_ITEMS_POOL, 0);
            idToIndex.put((Object)SELL_SPECIAL_ITEMS_POOL, 1);
            idToIndex.put((Object)SELL_COMMON_ITEMS_POOL, 2);
        });
        private static final Map<class_2960, class_3853.class_1652[]> DELAYED_MODIFICATIONS = new HashMap<class_2960, class_3853.class_1652[]>();

        static void initWanderingTraderTrades() {
            if (!(class_3853.field_45129 instanceof ArrayList)) {
                class_3853.field_45129 = new ArrayList(class_3853.field_45129);
            }
        }

        @Override
        public TradeOfferHelper.WanderingTraderOffersBuilder pool(class_2960 id, int count, class_3853.class_1652 ... factories) {
            if (factories.length == 0) {
                throw new IllegalArgumentException("cannot add empty pool");
            }
            if (count <= 0) {
                throw new IllegalArgumentException("count must be positive");
            }
            Objects.requireNonNull(id, "id cannot be null");
            if (ID_TO_INDEX.containsKey((Object)id)) {
                throw new IllegalArgumentException("pool id %s is already registered".formatted(id));
            }
            Pair pool = Pair.of((Object)factories, (Object)count);
            WanderingTraderOffersBuilderImpl.initWanderingTraderTrades();
            ID_TO_INDEX.put((Object)id, class_3853.field_45129.size());
            class_3853.field_45129.add(pool);
            class_3853.class_1652[] delayedModifications = DELAYED_MODIFICATIONS.remove(id);
            if (delayedModifications != null) {
                this.addOffersToPool(id, delayedModifications);
            }
            return this;
        }

        @Override
        public TradeOfferHelper.WanderingTraderOffersBuilder addOffersToPool(class_2960 pool, class_3853.class_1652 ... factories) {
            if (!ID_TO_INDEX.containsKey((Object)pool)) {
                DELAYED_MODIFICATIONS.compute(pool, (id, current) -> {
                    if (current == null) {
                        return factories;
                    }
                    return (class_3853.class_1652[])ArrayUtils.addAll((Object[])current, (Object[])factories);
                });
                return this;
            }
            int poolIndex = ID_TO_INDEX.getInt((Object)pool);
            WanderingTraderOffersBuilderImpl.initWanderingTraderTrades();
            Pair poolPair = (Pair)class_3853.field_45129.get(poolIndex);
            class_3853.class_1652[] modified = (class_3853.class_1652[])ArrayUtils.addAll((Object[])((class_3853.class_1652[])poolPair.getLeft()), (Object[])factories);
            class_3853.field_45129.set(poolIndex, Pair.of((Object)modified, (Object)((Integer)poolPair.getRight())));
            return this;
        }
    }
}

