/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.object.builder;

import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

import org.jetbrains.annotations.Nullable;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityType;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_2902;
import net.minecraft.class_5132;
import net.minecraft.class_9168;

public interface FabricEntityTypeImpl {
	void fabric_setAlwaysUpdateVelocity(Boolean alwaysUpdateVelocity);

	interface Builder {
		void fabric_setLivingEntityBuilder(Living<? extends class_1309> livingBuilder);

		void fabric_setMobEntityBuilder(Mob<? extends class_1308> mobBuilder);

		static <T extends class_1309> class_1299.class_1300<T> createLiving(class_1299.class_4049<T> factory, class_1311 spawnGroup, UnaryOperator<FabricEntityType.Builder.Living<T>> livingBuilder) {
			class_1299.class_1300<T> builder = class_1299.class_1300.method_5903(factory, spawnGroup);
			Living<T> builderImpl = new Living<>();
			livingBuilder.apply(builderImpl);
			((Builder) builder).fabric_setLivingEntityBuilder(builderImpl);
			return builder;
		}

		static <T extends class_1308> class_1299.class_1300<T> createMob(class_1299.class_4049<T> factory, class_1311 spawnGroup, UnaryOperator<FabricEntityType.Builder.Mob<T>> mobBuilder) {
			class_1299.class_1300<T> builder = class_1299.class_1300.method_5903(factory, spawnGroup);
			Mob<T> builderImpl = new Mob<>();
			mobBuilder.apply(builderImpl);
			((Builder) builder).fabric_setMobEntityBuilder(builderImpl);
			return builder;
		}

		sealed class Living<T extends class_1309> implements FabricEntityType.Builder.Living<T> permits Mob {
			@Nullable
			private Supplier<class_5132.class_5133> defaultAttributeBuilder;

			@Override
			public FabricEntityType.Builder.Living<T> defaultAttributes(Supplier<class_5132.class_5133> defaultAttributeBuilder) {
				Objects.requireNonNull(defaultAttributeBuilder, "Cannot set null attribute builder");
				this.defaultAttributeBuilder = defaultAttributeBuilder;
				return this;
			}

			public void onBuild(class_1299<T> type) {
				if (this.defaultAttributeBuilder != null) {
					FabricDefaultAttributeRegistry.register(type, this.defaultAttributeBuilder.get());
				}
			}
		}

		final class Mob<T extends class_1308> extends Living<T> implements FabricEntityType.Builder.Mob<T> {
			private class_9168 restrictionLocation;
			private class_2902.class_2903 restrictionHeightmap;
			private class_1317.class_4306<T> spawnPredicate;

			@Override
			public FabricEntityType.Builder.Mob<T> spawnRestriction(class_9168 location, class_2902.class_2903 heightmap, class_1317.class_4306<T> spawnPredicate) {
				this.restrictionLocation = Objects.requireNonNull(location, "Location cannot be null.");
				this.restrictionHeightmap = Objects.requireNonNull(heightmap, "Heightmap type cannot be null.");
				this.spawnPredicate = Objects.requireNonNull(spawnPredicate, "Spawn predicate cannot be null.");
				return this;
			}

			@Override
			public FabricEntityType.Builder.Mob<T> defaultAttributes(Supplier<class_5132.class_5133> defaultAttributeBuilder) {
				super.defaultAttributes(defaultAttributeBuilder);
				return this;
			}

			public void onBuild(class_1299<T> type) {
				super.onBuild(type);

				if (this.spawnPredicate != null) {
					class_1317.method_20637(type, this.restrictionLocation, this.restrictionHeightmap, this.spawnPredicate);
				}
			}
		}
	}
}
