/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.object.builder;

import java.util.stream.Stream;
import net.minecraft.class_1297;
import net.minecraft.class_1914;
import net.minecraft.class_3853;
import net.minecraft.class_3854;
import net.minecraft.class_5819;
import net.minecraft.class_7922;
import net.minecraft.class_9306;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3853.class_4162.class)
public abstract class TradeOffersTypeAwareBuyForOneEmeraldFactoryMixin {
	/**
	 * Vanilla will check the "VillagerType -> Item" map in the stream and throw an exception for villager types not specified in the map.
	 * This breaks any and all custom villager types.
	 * We want to prevent this default logic so modded villager types will work.
	 * So we return an empty stream so an exception is never thrown.
	 */
	@Redirect(method = "<init>", at = @At(value = "INVOKE", target = "Lnet/minecraft/registry/DefaultedRegistry;stream()Ljava/util/stream/Stream;"))
	private <T> Stream<T> disableVanillaCheck(class_7922<class_3854> instance) {
		return Stream.empty();
	}

	/**
	 * To prevent "item" -> "air" trades, if the result of a type aware trade is air, make sure no offer is created.
	 */
	@Inject(method = "create", at = @At(value = "NEW", target = "net/minecraft/village/TradeOffer"), cancellable = true)
	private void failOnNullItem(class_1297 entity, class_5819 random, CallbackInfoReturnable<class_1914> cir, @Local() class_9306 tradedItem) {
		if (tradedItem.comp_2427().method_7960()) { // Will return true for an "empty" item stack that had null passed in the ctor
			cir.setReturnValue(null); // Return null to prevent creation of empty trades
		}
	}
}
