/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.particle.v1;

import java.util.Locale;
import java.util.function.Function;
import net.fabricmc.fabric.impl.client.particle.ParticleRendererRegistryImpl;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleGroup;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;

public final class ParticleRendererRegistry {
    public static void register(ParticleRenderType textureSheet, Function<ParticleEngine, ParticleGroup<?>> function) {
        ParticleRendererRegistryImpl.INSTANCE.register(textureSheet, function);
    }

    public static void registerOrdering(ParticleRenderType first, Identifier second) {
        ParticleRendererRegistry.registerOrdering(ParticleRendererRegistry.getId(first), second);
    }

    public static void registerOrdering(ParticleRenderType first, ParticleRenderType second) {
        ParticleRendererRegistry.registerOrdering(ParticleRendererRegistry.getId(first), ParticleRendererRegistry.getId(second));
    }

    public static void registerOrdering(Identifier first, ParticleRenderType second) {
        ParticleRendererRegistry.registerOrdering(first, ParticleRendererRegistry.getId(second));
    }

    public static void registerOrdering(Identifier first, Identifier second) {
        ParticleRendererRegistryImpl.INSTANCE.registerOrdering(first, second);
    }

    public static @Nullable ParticleRenderType getParticleTextureSheet(Identifier id) {
        return ParticleRendererRegistryImpl.INSTANCE.getParticleTextureSheet(id);
    }

    public static Identifier getId(ParticleRenderType textureSheet) {
        if (textureSheet == ParticleRenderType.SINGLE_QUADS || textureSheet == ParticleRenderType.NO_RENDER || textureSheet == ParticleRenderType.ELDER_GUARDIANS || textureSheet == ParticleRenderType.ITEM_PICKUP) {
            return Identifier.withDefaultNamespace((String)textureSheet.name().toLowerCase(Locale.ROOT));
        }
        return Identifier.parse((String)textureSheet.name());
    }

    private ParticleRendererRegistry() {
    }
}

