/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.particle;

import net.fabricmc.fabric.impl.particle.BlockStateParticleEffectExtension;
import net.fabricmc.fabric.impl.particle.ExtendedBlockStateParticleEffectSync;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class ExtendedBlockStateParticleEffectPacketCodec
implements StreamCodec<RegistryFriendlyByteBuf, BlockParticleOption> {
    private static final int PACKET_MARKER = -1;
    private final StreamCodec<? super RegistryFriendlyByteBuf, BlockParticleOption> fallback;

    public ExtendedBlockStateParticleEffectPacketCodec(StreamCodec<? super RegistryFriendlyByteBuf, BlockParticleOption> fallback) {
        this.fallback = fallback;
    }

    public BlockParticleOption decode(RegistryFriendlyByteBuf buf) {
        int index = buf.readerIndex();
        if (buf.readVarInt() != -1) {
            buf.readerIndex(index);
            return (BlockParticleOption)this.fallback.decode((Object)buf);
        }
        BlockParticleOption value = (BlockParticleOption)this.fallback.decode((Object)buf);
        BlockPos pos = (BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf);
        ((BlockStateParticleEffectExtension)value).fabric_setBlockPos(pos);
        return value;
    }

    public void encode(RegistryFriendlyByteBuf buf, BlockParticleOption value) {
        BlockPos pos = value.getBlockPos();
        if (pos == null || ExtendedBlockStateParticleEffectSync.shouldEncodeFallback(buf)) {
            this.fallback.encode((Object)buf, (Object)value);
            return;
        }
        buf.writeVarInt(-1);
        this.fallback.encode((Object)buf, (Object)value);
        BlockPos.STREAM_CODEC.encode((Object)buf, (Object)pos);
    }
}

