/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.particle;

import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class ExtendedBlockStateParticleEffectPacketCodec implements class_9139<class_9129, class_2388> {
	private static final int PACKET_MARKER = -1;
	private final class_9139<? super class_9129, class_2388> fallback;

	public ExtendedBlockStateParticleEffectPacketCodec(class_9139<? super class_9129, class_2388> fallback) {
		this.fallback = fallback;
	}

	@Override
	public class_2388 decode(class_9129 buf) {
		int index = buf.readerIndex();

		if (buf.method_10816() != PACKET_MARKER) {
			// Reset index for vanilla's normal deserialization logic.
			buf.method_52988(index);
			return fallback.decode(buf);
		}

		class_2388 value = fallback.decode(buf);
		class_2338 pos = class_2338.field_48404.decode(buf);
		((BlockStateParticleEffectExtension) value).fabric_setBlockPos(pos);
		return value;
	}

	@Override
	public void encode(class_9129 buf, class_2388 value) {
		class_2338 pos = value.getBlockPos();

		if (pos == null || ExtendedBlockStateParticleEffectSync.shouldEncodeFallback(buf)) {
			fallback.encode(buf, value);
			return;
		}

		buf.method_10804(PACKET_MARKER);
		fallback.encode(buf, value);
		class_2338.field_48404.encode(buf, pos);
	}
}
