/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Function;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

abstract class CombinedIngredient
implements CustomIngredient {
    protected final class_1856[] ingredients;

    protected CombinedIngredient(class_1856[] ingredients) {
        if (ingredients.length == 0) {
            throw new IllegalArgumentException("ALL or ANY ingredient must have at least one sub-ingredient");
        }
        this.ingredients = ingredients;
    }

    @Override
    public boolean requiresTesting() {
        for (class_1856 ingredient : this.ingredients) {
            if (!ingredient.requiresTesting()) continue;
            return true;
        }
        return false;
    }

    static class Serializer<I extends CombinedIngredient>
    implements CustomIngredientSerializer<I> {
        private final class_2960 identifier;
        private final Function<class_1856[], I> factory;

        Serializer(class_2960 identifier, Function<class_1856[], I> factory) {
            this.identifier = identifier;
            this.factory = factory;
        }

        @Override
        public class_2960 getIdentifier() {
            return this.identifier;
        }

        @Override
        public I read(JsonObject json) {
            JsonArray values = class_3518.method_15261((JsonObject)json, (String)"ingredients");
            class_1856[] ingredients = new class_1856[values.size()];
            for (int i = 0; i < values.size(); ++i) {
                ingredients[i] = class_1856.method_52177((JsonElement)values.get(i));
            }
            return (I)((CombinedIngredient)this.factory.apply(ingredients));
        }

        @Override
        public void write(JsonObject json, I ingredient) {
            JsonArray values = new JsonArray();
            for (class_1856 value : ((CombinedIngredient)ingredient).ingredients) {
                values.add(value.method_8089());
            }
            json.add("ingredients", (JsonElement)values);
        }

        @Override
        public I read(class_2540 buf) {
            int size = buf.method_10816();
            class_1856[] ingredients = new class_1856[size];
            for (int i = 0; i < size; ++i) {
                ingredients[i] = class_1856.method_8086((class_2540)buf);
            }
            return (I)((CombinedIngredient)this.factory.apply(ingredients));
        }

        @Override
        public void write(class_2540 buf, I ingredient) {
            buf.method_10804(((CombinedIngredient)ingredient).ingredients.length);
            for (class_1856 value : ((CombinedIngredient)ingredient).ingredients) {
                value.method_8088(buf);
            }
        }
    }
}

