/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2522;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.jetbrains.annotations.Nullable;

public class NbtIngredient
implements CustomIngredient {
    public static final CustomIngredientSerializer<NbtIngredient> SERIALIZER = new Serializer();
    private final class_1856 base;
    @Nullable
    private final class_2487 nbt;
    private final boolean strict;

    public NbtIngredient(class_1856 base, @Nullable class_2487 nbt, boolean strict) {
        if (nbt == null && !strict) {
            throw new IllegalArgumentException("NbtIngredient can only have null NBT in strict mode");
        }
        this.base = base;
        this.nbt = nbt;
        this.strict = strict;
    }

    @Override
    public boolean test(class_1799 stack) {
        if (!this.base.method_8093(stack)) {
            return false;
        }
        if (this.strict) {
            return Objects.equals(this.nbt, stack.method_7969());
        }
        return class_2512.method_10687((class_2520)this.nbt, (class_2520)stack.method_7969(), (boolean)true);
    }

    @Override
    public List<class_1799> getMatchingStacks() {
        ArrayList<class_1799> stacks = new ArrayList<class_1799>(List.of(this.base.method_8105()));
        stacks.replaceAll(stack -> {
            class_1799 copy = stack.method_7972();
            if (this.nbt != null) {
                copy.method_7980(this.nbt.method_10553());
            }
            return copy;
        });
        stacks.removeIf(stack -> !this.base.method_8093(stack));
        return stacks;
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public CustomIngredientSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static class Serializer
    implements CustomIngredientSerializer<NbtIngredient> {
        private final Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        private final class_2960 id = new class_2960("fabric", "nbt");

        private Serializer() {
        }

        @Override
        public class_2960 getIdentifier() {
            return this.id;
        }

        @Override
        public NbtIngredient read(JsonObject json) {
            class_1856 base = class_1856.method_52177((JsonElement)json.get("base"));
            class_2487 nbt = Serializer.readNbt(json.get("nbt"));
            boolean strict = class_3518.method_15258((JsonObject)json, (String)"strict", (boolean)false);
            return new NbtIngredient(base, nbt, strict);
        }

        @Nullable
        private static class_2487 readNbt(@Nullable JsonElement json) {
            if (json == null || json.isJsonNull()) {
                return null;
            }
            try {
                if (json.isJsonObject()) {
                    return class_2522.method_10718((String)json.toString());
                }
                return class_2522.method_10718((String)class_3518.method_15287((JsonElement)json, (String)"nbt"));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                throw new JsonSyntaxException("Invalid nbt tag: " + commandSyntaxException.getMessage());
            }
        }

        @Override
        public void write(JsonObject json, NbtIngredient ingredient) {
            json.add("base", ingredient.base.method_8089());
            json.addProperty("strict", Boolean.valueOf(ingredient.strict));
            if (ingredient.nbt != null) {
                json.add("nbt", (JsonElement)class_2509.field_11560.method_29146((DynamicOps)JsonOps.INSTANCE, (class_2520)ingredient.nbt));
            }
        }

        @Override
        public NbtIngredient read(class_2540 buf) {
            class_1856 base = class_1856.method_8086((class_2540)buf);
            class_2487 nbt = buf.method_10798();
            boolean strict = buf.readBoolean();
            return new NbtIngredient(base, nbt, strict);
        }

        @Override
        public void write(class_2540 buf, NbtIngredient ingredient) {
            ingredient.base.method_8088(buf);
            buf.method_10794(ingredient.nbt);
            buf.writeBoolean(ingredient.strict);
        }
    }
}

