/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.recipe.sync;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.impl.recipe.sync.RecipeSyncPayloadS2C;
import net.fabricmc.fabric.impl.recipe.sync.SupportedRecipeSerializersPayloadC2S;
import net.fabricmc.fabric.impl.recipe.sync.SyncedSerializerAwareClientConnection;
import net.fabricmc.fabric.impl.recipe.sync.SyncedSerializerAwarePreparedRecipe;
import net.fabricmc.fabric.mixin.recipe.sync.ServerCommonNetworkHandlerAccessor;
import net.fabricmc.fabric.mixin.recipe.sync.ServerRecipeManagerAccessor;
import net.minecraft.class_1865;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import net.minecraft.class_8710;
import net.minecraft.class_8786;

public class RecipeSyncImpl
implements ModInitializer {
    private static final int RECIPE_PAYLOAD_MAX_SIZE = 0x4000000;
    private static final Set<class_1865<?>> SYNCED_SERIALIZERS = new ReferenceOpenHashSet();
    public static final class_2960 RECIPE_SYNC_EVENT_PHASE = class_2960.method_60655((String)"fabric", (String)"recipe_sync");

    public void onInitialize() {
        PayloadTypeRegistry.configurationC2S().register(SupportedRecipeSerializersPayloadC2S.ID, SupportedRecipeSerializersPayloadC2S.CODEC);
        PayloadTypeRegistry.playS2C().registerLarge(RecipeSyncPayloadS2C.ID, RecipeSyncPayloadS2C.CODEC, 0x4000000);
        ServerConfigurationNetworking.registerGlobalReceiver(SupportedRecipeSerializersPayloadC2S.ID, RecipeSyncImpl::onRecipeSyncRequest);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.addPhaseOrdering(Event.DEFAULT_PHASE, RECIPE_SYNC_EVENT_PHASE);
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register(RECIPE_SYNC_EVENT_PHASE, RecipeSyncImpl::sendRecipes);
    }

    private static void onRecipeSyncRequest(SupportedRecipeSerializersPayloadC2S payload, ServerConfigurationNetworking.Context context) {
        ReferenceOpenHashSet set = new ReferenceOpenHashSet();
        for (class_2960 identifier : payload.synchronizedSerializers()) {
            class_7923.field_41189.method_17966(identifier).ifPresent(arg_0 -> ((ReferenceOpenHashSet)set).add(arg_0));
        }
        ((SyncedSerializerAwareClientConnection)((ServerCommonNetworkHandlerAccessor)context.networkHandler()).getConnection()).fabric_setSyncedRecipeSerializers((Set<class_1865<?>>)set);
    }

    private static void sendRecipes(class_3222 player, boolean exist) {
        if (!ServerPlayNetworking.canSend((class_3222)player, RecipeSyncPayloadS2C.ID)) {
            return;
        }
        Set<class_1865<?>> serializers = ((SyncedSerializerAwareClientConnection)((ServerCommonNetworkHandlerAccessor)player.field_13987).getConnection()).fabric_getSyncedRecipeSerializers();
        SyncedSerializerAwarePreparedRecipe accessor = (SyncedSerializerAwarePreparedRecipe)((ServerRecipeManagerAccessor)player.method_51469().method_64577()).getPreparedRecipes();
        ArrayList<RecipeSyncPayloadS2C.Entry> list = new ArrayList<RecipeSyncPayloadS2C.Entry>();
        for (class_1865<?> serializer : serializers) {
            List<class_8786<?>> recipes = accessor.fabric_getRecipesBySyncedSerializer(serializer);
            if (recipes == null || recipes.isEmpty()) continue;
            list.add(new RecipeSyncPayloadS2C.Entry(serializer, recipes));
        }
        if (list.isEmpty()) {
            return;
        }
        ServerPlayNetworking.send((class_3222)player, (class_8710)new RecipeSyncPayloadS2C(list));
    }

    public static void addSynchronizedSerializer(class_1865<?> serializer) {
        SYNCED_SERIALIZERS.add(serializer);
    }

    public static boolean isSynced(class_1865<?> serializer) {
        return SYNCED_SERIALIZERS.contains(serializer);
    }

    public static Set<class_1865<?>> getSyncedSerializers() {
        return Collections.unmodifiableSet(SYNCED_SERIALIZERS);
    }
}

