/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.recipe.ingredient.builtin;

import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class DifferenceIngredient implements CustomIngredient {
	public static final CustomIngredientSerializer<DifferenceIngredient> SERIALIZER = new Serializer();

	private final class_1856 base;
	private final class_1856 subtracted;

	public DifferenceIngredient(class_1856 base, class_1856 subtracted) {
		this.base = base;
		this.subtracted = subtracted;
	}

	@Override
	public boolean test(class_1799 stack) {
		return base.method_8093(stack) && !subtracted.method_8093(stack);
	}

	@Override
	public Stream<class_6880<class_1792>> getMatchingItems() {
		final List<class_6880<class_1792>> subtractedMatchingItems = subtracted.method_8105().toList();
		return base.method_8105()
				.filter(registryEntry -> !subtractedMatchingItems.contains(registryEntry));
	}

	@Override
	public boolean requiresTesting() {
		return base.requiresTesting() || subtracted.requiresTesting();
	}

	@Override
	public CustomIngredientSerializer<?> getSerializer() {
		return SERIALIZER;
	}

	private class_1856 getBase() {
		return base;
	}

	private class_1856 getSubtracted() {
		return subtracted;
	}

	@Override
	public boolean equals(Object o) {
		if (this == o) return true;
		if (o == null || getClass() != o.getClass()) return false;
		DifferenceIngredient that = (DifferenceIngredient) o;
		return base.equals(that.base) && subtracted.equals(that.subtracted);
	}

	@Override
	public int hashCode() {
		return Objects.hash(base, subtracted);
	}

	private static class Serializer implements CustomIngredientSerializer<DifferenceIngredient> {
		private static final class_2960 ID = class_2960.method_60655("fabric", "difference");
		private static final MapCodec<DifferenceIngredient> CODEC = RecordCodecBuilder.mapCodec(instance ->
				instance.group(
						class_1856.field_46095.fieldOf("base").forGetter(DifferenceIngredient::getBase),
						class_1856.field_46095.fieldOf("subtracted").forGetter(DifferenceIngredient::getSubtracted)
				).apply(instance, DifferenceIngredient::new)
		);
		private static final class_9139<class_9129, DifferenceIngredient> PACKET_CODEC = class_9139.method_56435(
				class_1856.field_48355, DifferenceIngredient::getBase,
				class_1856.field_48355, DifferenceIngredient::getSubtracted,
				DifferenceIngredient::new
		);

		@Override
		public class_2960 getIdentifier() {
			return ID;
		}

		@Override
		public MapCodec<DifferenceIngredient> getCodec() {
			return CODEC;
		}

		@Override
		public class_9139<class_9129, DifferenceIngredient> getPacketCodec() {
			return PACKET_CODEC;
		}
	}
}
