/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.registry.sync;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.registry.RegistryAttribute;
import net.fabricmc.fabric.api.event.registry.RegistryAttributeHolder;
import net.minecraft.class_2378;

public class FabricRegistryInit implements ModInitializer {
	@Override
	public void onInitialize() {
		// Synced in PlaySoundS2CPacket.
		RegistryAttributeHolder.get(class_2378.field_11156)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced with RegistryTagContainer from RegistryTagManager.
		RegistryAttributeHolder.get(class_2378.field_11154)
				.addAttribute(RegistryAttribute.SYNCED);

		// StatusEffectInstance serialises with raw id.
		RegistryAttributeHolder.get(class_2378.field_11159)
				.addAttribute(RegistryAttribute.SYNCED)
				.addAttribute(RegistryAttribute.PERSISTED);

		// Synced in ChunkDeltaUpdateS2CPacket among other places, a pallet is used when saving.
		RegistryAttributeHolder.get(class_2378.field_11146)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in EnchantmentScreenHandler
		RegistryAttributeHolder.get(class_2378.field_11160)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in EntitySpawnS2CPacket and RegistryTagManager
		RegistryAttributeHolder.get(class_2378.field_11145)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced in RegistryTagManager
		RegistryAttributeHolder.get(class_2378.field_11142)
				.addAttribute(RegistryAttribute.SYNCED);

		// Saved and synced using string ID.
		RegistryAttributeHolder.get(class_2378.field_11143);

		// Doesnt seem to be accessed apart from registering?
		RegistryAttributeHolder.get(class_2378.field_11157);

		// Doesnt seem to be accessed apart from registering?
		RegistryAttributeHolder.get(class_2378.field_11147);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_11138);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_11148);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_21445);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_21446);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_21447);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_23782);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_21448);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_24331);

		// Synced in ParticleS2CPacket
		RegistryAttributeHolder.get(class_2378.field_11141)
				.addAttribute(RegistryAttribute.SYNCED);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_25096);

		// Not synced or saved
		RegistryAttributeHolder.get(class_2378.field_11137);

		// Synced in PaintingSpawnS2CPacket
		RegistryAttributeHolder.get(class_2378.field_11150)
				.addAttribute(RegistryAttribute.SYNCED);

		// Doesnt seem to be synced or saved, STAT_TYPE seems to handle the syncing.
		RegistryAttributeHolder.get(class_2378.field_11158);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_16643);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_16644);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_16645);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_16792);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_23398);

		RegistryAttributeHolder.get(class_2378.field_16794);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_16793);

		// Synced in OpenScreenS2CPacket
		RegistryAttributeHolder.get(class_2378.field_17429)
				.addAttribute(RegistryAttribute.SYNCED);

		// Does not seem to be serialised, only queried by id. Not synced
		RegistryAttributeHolder.get(class_2378.field_17597);

		// Synced by id
		RegistryAttributeHolder.get(class_2378.field_17598);

		// Synced and saved by id
		RegistryAttributeHolder.get(class_2378.field_23781);

		// Synced in StatisticsS2CPacket
		RegistryAttributeHolder.get(class_2378.field_11152)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced by rawID in TrackedDataHandlerRegistry.VILLAGER_DATA
		RegistryAttributeHolder.get(class_2378.field_17166)
				.addAttribute(RegistryAttribute.SYNCED);

		// Synced by rawID in TrackedDataHandlerRegistry.VILLAGER_DATA
		RegistryAttributeHolder.get(class_2378.field_17167)
				.addAttribute(RegistryAttribute.SYNCED);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_18792);

		// Serialised by string, doesnt seem to be synced
		RegistryAttributeHolder.get(class_2378.field_18793);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_2378.field_18794);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_2378.field_18795);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_2378.field_18796);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_2378.field_25293);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_2378.field_25294);

		// Doesnt seem to be serialised or synced.
		RegistryAttributeHolder.get(class_2378.field_25299);
	}
}
