/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.registry.sync;

import java.io.IOException;
import java.nio.file.Path;

import com.mojang.serialization.DynamicOps;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import net.minecraft.class_2520;
import net.minecraft.class_32;
import net.minecraft.class_3300;
import net.minecraft.class_5382;
import net.minecraft.class_5455;
import net.minecraft.server.Main;
import net.fabricmc.fabric.impl.registry.sync.PersistentDynamicRegistryHandler;

@Mixin(Main.class)
public class MixinMain {
	@Unique
	private static Path fabric_saveDir;

	@Redirect(method = "main", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/storage/LevelStorage;createSession(Ljava/lang/String;)Lnet/minecraft/world/level/storage/LevelStorage$Session;"))
	private static class_32.class_5143 levelStorageCreateSession(class_32 levelStorage, String levelName) throws IOException {
		class_32.class_5143 session = levelStorage.method_27002(levelName);
		fabric_saveDir = ((AccessorLevelStorageSession) session).getDirectory();
		return session;
	}

	@Redirect(method = "main", at = @At(value = "INVOKE", target = "Lnet/minecraft/util/dynamic/RegistryOps;of(Lcom/mojang/serialization/DynamicOps;Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/util/registry/DynamicRegistryManager$Impl;)Lnet/minecraft/util/dynamic/RegistryOps;"))
	private static class_5382<class_2520> ofRegistryOps(DynamicOps<class_2520> delegate, class_3300 resourceManager, class_5455.class_5457 impl) {
		class_5382<class_2520> registryOps = class_5382.method_29753(delegate, resourceManager, impl);
		PersistentDynamicRegistryHandler.remapDynamicRegistries(impl, fabric_saveDir);
		return registryOps;
	}
}
