/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.registry.sync;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryRemovedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryIdRemapCallback;
import net.fabricmc.fabric.impl.registry.sync.ListenableRegistry;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.RemapStateImpl;
import net.fabricmc.fabric.impl.registry.sync.RemappableRegistry;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_2370.class})
public abstract class MixinIdRegistry<T>
extends class_2378<T>
implements RemappableRegistry,
ListenableRegistry<T> {
    @Shadow
    @Final
    private ObjectList<T> field_26682;
    @Shadow
    @Final
    private Object2IntMap<T> field_26683;
    @Shadow
    @Final
    private BiMap<class_2960, T> field_11107;
    @Shadow
    @Final
    private BiMap<class_5321<T>, T> field_25067;
    @Shadow
    private int field_11109;
    @Unique
    private static Logger FABRIC_LOGGER = LogManager.getLogger();
    @Unique
    private final Event<RegistryEntryAddedCallback<T>> fabric_addObjectEvent = EventFactory.createArrayBacked(RegistryEntryAddedCallback.class, callbacks -> (rawId, id, object) -> {
        for (RegistryEntryAddedCallback callback : callbacks) {
            callback.onEntryAdded(rawId, id, object);
        }
    });
    @Unique
    private final Event<RegistryEntryRemovedCallback<T>> fabric_removeObjectEvent = EventFactory.createArrayBacked(RegistryEntryRemovedCallback.class, callbacks -> (rawId, id, object) -> {
        for (RegistryEntryRemovedCallback callback : callbacks) {
            callback.onEntryRemoved(rawId, id, object);
        }
    });
    @Unique
    private final Event<RegistryIdRemapCallback<T>> fabric_postRemapEvent = EventFactory.createArrayBacked(RegistryIdRemapCallback.class, callbacks -> a -> {
        for (RegistryIdRemapCallback callback : callbacks) {
            callback.onRemap(a);
        }
    });
    @Unique
    private Object2IntMap<class_2960> fabric_prevIndexedEntries;
    @Unique
    private BiMap<class_2960, T> fabric_prevEntries;
    @Unique
    private boolean fabric_isObjectNew = false;

    public MixinIdRegistry(class_5321<? extends class_2378<T>> key, Lifecycle lifecycle) {
        super(key, lifecycle);
    }

    @Override
    public Event<RegistryEntryAddedCallback<T>> fabric_getAddObjectEvent() {
        return this.fabric_addObjectEvent;
    }

    @Override
    public Event<RegistryEntryRemovedCallback<T>> fabric_getRemoveObjectEvent() {
        return this.fabric_removeObjectEvent;
    }

    @Override
    public Event<RegistryIdRemapCallback<T>> fabric_getRemapEvent() {
        return this.fabric_postRemapEvent;
    }

    @Inject(method={"set(ILnet/minecraft/util/registry/RegistryKey;Ljava/lang/Object;Lcom/mojang/serialization/Lifecycle;Z)Ljava/lang/Object;"}, at={@At(value="HEAD")})
    public void setPre(int id, class_5321<T> registryId, T object, Lifecycle lifecycle, boolean checkDuplicateKeys, CallbackInfoReturnable<T> info) {
        int indexedEntriesId = this.field_26683.getInt(object);
        if (indexedEntriesId >= 0) {
            throw new RuntimeException("Attempted to register object " + object + " twice! (at raw IDs " + indexedEntriesId + " and " + id + " )");
        }
        if (!this.field_11107.containsKey((Object)registryId.method_29177())) {
            this.fabric_isObjectNew = true;
        } else {
            Object oldObject = this.field_11107.get((Object)registryId.method_29177());
            if (oldObject != null && oldObject != object) {
                int oldId = this.field_26683.getInt(oldObject);
                if (oldId != id && checkDuplicateKeys) {
                    throw new RuntimeException("Attempted to register ID " + registryId + " at different raw IDs (" + oldId + ", " + id + ")! If you're trying to override an item, use .set(), not .register()!");
                }
                ((RegistryEntryRemovedCallback)this.fabric_removeObjectEvent.invoker()).onEntryRemoved(oldId, registryId.method_29177(), oldObject);
                this.fabric_isObjectNew = true;
            } else {
                this.fabric_isObjectNew = false;
            }
        }
    }

    @Inject(method={"set(ILnet/minecraft/util/registry/RegistryKey;Ljava/lang/Object;Lcom/mojang/serialization/Lifecycle;Z)Ljava/lang/Object;"}, at={@At(value="RETURN")})
    public void setPost(int id, class_5321<T> registryId, T object, Lifecycle lifecycle, boolean checkDuplicateKeys, CallbackInfoReturnable<T> info) {
        if (this.fabric_isObjectNew) {
            ((RegistryEntryAddedCallback)this.fabric_addObjectEvent.invoker()).onEntryAdded(id, registryId.method_29177(), object);
        }
    }

    @Override
    public void remap(String name, Object2IntMap<class_2960> remoteIndexedEntries, RemappableRegistry.RemapMode mode) throws RemapException {
        class_2960 id2;
        Iterator o;
        Object strings;
        switch (mode) {
            case AUTHORITATIVE: {
                break;
            }
            case REMOTE: {
                Object remoteId2;
                strings = null;
                for (Object remoteId2 : remoteIndexedEntries.keySet()) {
                    if (this.field_11107.containsKey(remoteId2)) continue;
                    if (strings == null) {
                        strings = new ArrayList();
                    }
                    strings.add(" - " + remoteId2);
                }
                if (strings == null) break;
                StringBuilder builder = new StringBuilder("Received ID map for " + name + " contains IDs unknown to the receiver!");
                remoteId2 = strings.iterator();
                while (remoteId2.hasNext()) {
                    String s = (String)remoteId2.next();
                    builder.append('\n').append(s);
                }
                throw new RemapException(builder.toString());
            }
            case EXACT: {
                if (this.field_11107.keySet().equals(remoteIndexedEntries.keySet())) break;
                ArrayList<String> strings2 = new ArrayList<String>();
                for (class_2960 remoteId : remoteIndexedEntries.keySet()) {
                    if (this.field_11107.containsKey((Object)remoteId)) continue;
                    strings2.add(" - " + remoteId + " (missing on local)");
                }
                for (Object localId : this.method_10235()) {
                    if (remoteIndexedEntries.containsKey(localId)) continue;
                    strings2.add(" - " + localId + " (missing on remote)");
                }
                StringBuilder builder = new StringBuilder("Local and remote ID sets for " + name + " do not match!");
                for (String s : strings2) {
                    builder.append('\n').append(s);
                }
                throw new RemapException(builder.toString());
            }
        }
        if (this.fabric_prevIndexedEntries == null) {
            this.fabric_prevIndexedEntries = new Object2IntOpenHashMap();
            this.fabric_prevEntries = HashBiMap.create(this.field_11107);
            strings = this.iterator();
            while (strings.hasNext()) {
                o = strings.next();
                this.fabric_prevIndexedEntries.put((Object)this.method_10221(o), this.method_10206(o));
            }
        }
        Int2ObjectOpenHashMap oldIdMap = new Int2ObjectOpenHashMap();
        o = this.iterator();
        while (o.hasNext()) {
            Object o2 = o.next();
            oldIdMap.put(this.method_10206(o2), (Object)this.method_10221(o2));
        }
        switch (mode) {
            case AUTHORITATIVE: {
                int maxValue = 0;
                Object2IntOpenHashMap oldRemoteIndexedEntries = remoteIndexedEntries;
                remoteIndexedEntries = new Object2IntOpenHashMap();
                for (class_2960 id2 : oldRemoteIndexedEntries.keySet()) {
                    int v = oldRemoteIndexedEntries.getInt((Object)id2);
                    remoteIndexedEntries.put((Object)id2, v);
                    if (v <= maxValue) continue;
                    maxValue = v;
                }
                for (class_2960 id2 : this.method_10235()) {
                    if (remoteIndexedEntries.containsKey((Object)id2)) continue;
                    FABRIC_LOGGER.warn("Adding " + id2 + " to saved/remote registry.");
                    remoteIndexedEntries.put((Object)id2, ++maxValue);
                }
                break;
            }
            case REMOTE: {
                int maxId = -1;
                for (class_2960 id3 : this.method_10235()) {
                    if (remoteIndexedEntries.containsKey((Object)id3)) continue;
                    if (maxId < 0) {
                        id2 = remoteIndexedEntries.values().iterator();
                        while (id2.hasNext()) {
                            int value = (Integer)id2.next();
                            if (value <= maxId) continue;
                            maxId = value;
                        }
                    }
                    if (maxId < 0) {
                        throw new RemapException("Failed to assign new id to client only registry entry");
                    }
                    FABRIC_LOGGER.debug("An ID for {} was not sent by the server, assuming client only registry entry and assigning a new id ({}) in {}", (Object)id3.toString(), (Object)(++maxId), (Object)this.method_30517().method_29177().toString());
                    remoteIndexedEntries.put((Object)id3, maxId);
                }
                break;
            }
        }
        Int2IntOpenHashMap idMap = new Int2IntOpenHashMap();
        for (Object o3 : this.field_26682) {
            id2 = this.method_10221(o3);
            int rid = this.method_10206(o3);
            if (!remoteIndexedEntries.containsKey((Object)id2)) continue;
            idMap.put(rid, remoteIndexedEntries.getInt((Object)id2));
        }
        this.field_26682.clear();
        this.field_26683.clear();
        this.field_11109 = 0;
        ArrayList<class_2960> orderedRemoteEntries = new ArrayList<class_2960>((Collection<class_2960>)remoteIndexedEntries.keySet());
        orderedRemoteEntries.sort(Comparator.comparingInt(arg_0 -> ((Object2IntMap)remoteIndexedEntries).getInt(arg_0)));
        for (class_2960 identifier : orderedRemoteEntries) {
            int id4 = remoteIndexedEntries.getInt((Object)identifier);
            Object object = this.field_11107.get((Object)identifier);
            if (object == null) {
                if (mode != RemappableRegistry.RemapMode.AUTHORITATIVE) {
                    throw new RemapException(identifier + " missing from registry, but requested!");
                }
                FABRIC_LOGGER.warn(identifier + " missing from registry, but requested!");
                continue;
            }
            this.field_26682.size(Math.max(this.field_26682.size(), id4 + 1));
            this.field_26682.set(id4, object);
            this.field_26683.put(object, id4);
            if (this.field_11109 > id4) continue;
            this.field_11109 = id4 + 1;
        }
        ((RegistryIdRemapCallback)this.fabric_getRemapEvent().invoker()).onRemap(new RemapStateImpl(this, (Int2ObjectMap<class_2960>)oldIdMap, (Int2IntMap)idMap));
    }

    @Override
    public void unmap(String name) throws RemapException {
        if (this.fabric_prevIndexedEntries != null) {
            ArrayList<class_2960> addedIds = new ArrayList<class_2960>();
            for (class_2960 id : this.fabric_prevEntries.keySet()) {
                if (this.field_11107.containsKey((Object)id)) continue;
                assert (this.fabric_prevIndexedEntries.containsKey((Object)id));
                addedIds.add(id);
            }
            this.field_11107.clear();
            this.field_25067.clear();
            this.field_11107.putAll(this.fabric_prevEntries);
            for (Map.Entry entry : this.fabric_prevEntries.entrySet()) {
                class_5321 entryKey = class_5321.method_29179((class_5321)this.method_30517(), (class_2960)((class_2960)entry.getKey()));
                this.field_25067.put((Object)entryKey, entry.getValue());
            }
            this.remap(name, this.fabric_prevIndexedEntries, RemappableRegistry.RemapMode.AUTHORITATIVE);
            for (class_2960 id : addedIds) {
                ((RegistryEntryAddedCallback)this.fabric_getAddObjectEvent().invoker()).onEntryAdded(this.field_26683.getInt(this.field_11107.get((Object)id)), id, this.field_11107.get((Object)id));
            }
            this.fabric_prevIndexedEntries = null;
            this.fabric_prevEntries = null;
        }
    }
}

