/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.registry.sync;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.fabric.impl.registry.sync.RegistrySyncManager;
import net.fabricmc.fabric.impl.registry.sync.RemapException;
import net.fabricmc.fabric.impl.registry.sync.RemappableRegistry;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_32;
import net.minecraft.class_5219;
import net.minecraft.class_5455;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_32.class_5143.class})
public class MixinLevelStorageSession {
    @Unique
    private static final int FABRIC_ID_REGISTRY_BACKUPS = 3;
    @Unique
    private static Logger FABRIC_LOGGER = LogManager.getLogger((String)"FabricRegistrySync");
    @Unique
    private class_2487 fabric_lastSavedIdMap = null;
    @Unique
    private class_2487 fabric_activeTag = null;
    @Shadow
    @Final
    private Path field_23768;

    @Unique
    private boolean fabric_readIdMapFile(File file) throws IOException, RemapException {
        FABRIC_LOGGER.debug("Reading registry data from " + file.toString());
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            class_2487 tag = class_2507.method_10629((InputStream)fileInputStream);
            fileInputStream.close();
            if (tag != null) {
                this.fabric_activeTag = RegistrySyncManager.apply(tag, RemappableRegistry.RemapMode.AUTHORITATIVE);
                return true;
            }
        }
        return false;
    }

    @Unique
    private File fabric_getWorldIdMapFile(int i) {
        return new File(new File(this.field_23768.toFile(), "data"), "fabricRegistry.dat" + (i == 0 ? "" : "." + i));
    }

    @Unique
    private void fabric_saveRegistryData() {
        FABRIC_LOGGER.debug("Starting registry save");
        class_2487 newIdMap = RegistrySyncManager.toTag(false, this.fabric_activeTag);
        if (newIdMap == null) {
            FABRIC_LOGGER.debug("Not saving empty registry data");
            return;
        }
        if (!newIdMap.equals((Object)this.fabric_lastSavedIdMap)) {
            for (int i = 2; i >= 0; --i) {
                File file = this.fabric_getWorldIdMapFile(i);
                if (!file.exists()) continue;
                if (i == 2) {
                    file.delete();
                    continue;
                }
                File target = this.fabric_getWorldIdMapFile(i + 1);
                file.renameTo(target);
            }
            try {
                File file = this.fabric_getWorldIdMapFile(0);
                File parentFile = file.getParentFile();
                if (!parentFile.exists() && !parentFile.mkdirs()) {
                    FABRIC_LOGGER.warn("[fabric-registry-sync] Could not create directory " + parentFile + "!");
                }
                FABRIC_LOGGER.debug("Saving registry data to " + file.toString());
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                class_2507.method_10634((class_2487)newIdMap, (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (IOException e) {
                FABRIC_LOGGER.warn("[fabric-registry-sync] Failed to save registry file!", (Throwable)e);
            }
            this.fabric_lastSavedIdMap = newIdMap;
        }
    }

    @Inject(method={"backupLevelDataFile(Lnet/minecraft/util/registry/DynamicRegistryManager;Lnet/minecraft/world/SaveProperties;Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD")})
    public void saveWorld(class_5455 registryTracker, class_5219 saveProperties, class_2487 compoundTag, CallbackInfo info) {
        if (!Files.exists(this.field_23768, new LinkOption[0])) {
            return;
        }
        this.fabric_saveRegistryData();
    }

    @Inject(method={"readLevelProperties"}, at={@At(value="HEAD")})
    public void readWorldProperties(CallbackInfoReturnable<class_5219> callbackInfo) {
        for (int i = 0; i < 3; ++i) {
            FABRIC_LOGGER.trace("[fabric-registry-sync] Loading Fabric registry [file " + (i + 1) + "/" + 4 + "]");
            try {
                if (!this.fabric_readIdMapFile(this.fabric_getWorldIdMapFile(i))) continue;
                FABRIC_LOGGER.info("[fabric-registry-sync] Loaded registry data [file " + (i + 1) + "/" + 4 + "]");
                return;
            }
            catch (FileNotFoundException fileNotFoundException) {
                continue;
            }
            catch (IOException e) {
                if (i >= 2) {
                    throw new RuntimeException(e);
                }
                FABRIC_LOGGER.warn("Reading registry file failed!", (Throwable)e);
                continue;
            }
            catch (RemapException e) {
                throw new RuntimeException("Remapping world failed!", e);
            }
        }
        this.fabric_saveRegistryData();
    }
}

