/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.event.registry;

import org.jetbrains.annotations.ApiStatus;
import net.fabricmc.fabric.impl.registry.sync.RegistryAttributeImpl;
import net.minecraft.class_2378;
import net.minecraft.class_5321;

@ApiStatus.NonExtendable
public interface RegistryAttributeHolder {
	static RegistryAttributeHolder get(class_5321<?> registryKey) {
		return RegistryAttributeImpl.getHolder(registryKey);
	}

	static RegistryAttributeHolder get(class_2378<?> registry) {
		return get(registry.method_46765());
	}

	RegistryAttributeHolder addAttribute(RegistryAttribute attribute);

	boolean hasAttribute(RegistryAttribute attribute);
}
