/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.api.renderer.v1.model;

import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.impl.renderer.DamageModel;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_777;
import net.minecraft.class_806;
import net.minecraft.class_809;

/**
 * Base class for specialized model implementations that need to wrap other baked models.
 * Avoids boilerplate code for pass-through methods. For example usage see {@link DamageModel}.
 */
public abstract class ForwardingBakedModel implements class_1087, FabricBakedModel {
	/** implementations must set this somehow. */
	protected class_1087 wrapped;

	@Override
	public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, RenderContext context) {
		((FabricBakedModel) wrapped).emitBlockQuads(blockView, state, pos, randomSupplier, context);
	}

	@Override
	public boolean isVanillaAdapter() {
		return ((FabricBakedModel) wrapped).isVanillaAdapter();
	}

	@Override
	public void emitItemQuads(class_1799 stack, Supplier<Random> randomSupplier, RenderContext context) {
		((FabricBakedModel) wrapped).emitItemQuads(stack, randomSupplier, context);
	}

	@Override
	public List<class_777> method_4707(class_2680 blockState, class_2350 face, Random rand) {
		return wrapped.method_4707(blockState, face, rand);
	}

	@Override
	public boolean method_4708() {
		return wrapped.method_4708();
	}

	@Override
	public boolean method_4712() {
		return wrapped.method_4712();
	}

	@Override
	public boolean method_4713() {
		return wrapped.method_4713();
	}

	@Override
	public class_1058 method_4711() {
		return wrapped.method_4711();
	}

	@Override
	public class_809 method_4709() {
		return wrapped.method_4709();
	}

	@Override
	public class_806 method_4710() {
		return wrapped.method_4710();
	}
}
