/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.renderer.block.particle;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.client.renderer.ScreenEffectRenderer;
import net.minecraft.client.renderer.block.BlockModelShaper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ScreenEffectRenderer.class})
abstract class ScreenEffectRendererMixin {
    @Unique
    private static @Nullable BlockPos pos;

    ScreenEffectRendererMixin() {
    }

    @Redirect(method={"renderScreenEffect"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/renderer/block/BlockModelShaper;getParticleIcon(Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;"))
    private static TextureAtlasSprite getParticleIconProxy(BlockModelShaper models, BlockState state, @Local(name={"player"}) Player player) {
        if (pos != null) {
            TextureAtlasSprite sprite = models.getParticleIcon(state, (BlockAndTintGetter)player.level(), pos);
            pos = null;
            return sprite;
        }
        return models.getParticleIcon(state);
    }

    @Inject(method={"getViewBlockingState"}, at={@At(value="RETURN")})
    private static void onReturnGetInWallBlockState(CallbackInfoReturnable<@Nullable BlockState> cir, @Local(name={"testPos"}) BlockPos.MutableBlockPos testPos) {
        pos = cir.getReturnValue() != null ? testPos.immutable() : null;
    }
}

