/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.renderer.block.render;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.fabric.impl.client.renderer.ExtendedBlockModelSubmit;
import net.fabricmc.fabric.impl.client.renderer.ExtendedBlockSubmit;
import net.fabricmc.fabric.impl.client.renderer.SubmitNodeCollectionExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OrderedSubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeCollection;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.SubmitNodeStorage;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SubmitNodeCollection.class})
abstract class SubmitNodeCollectionMixin
implements OrderedSubmitNodeCollector,
SubmitNodeCollectionExtension {
    @Shadow
    @Final
    private SubmitNodeStorage submitNodeStorage;
    @Shadow
    private boolean wasUsed;
    @Unique
    private final List<ExtendedBlockSubmit> extendedBlockSubmits = new ArrayList<ExtendedBlockSubmit>();
    @Unique
    private final List<ExtendedBlockModelSubmit> extendedBlockModelSubmits = new ArrayList<ExtendedBlockModelSubmit>();

    SubmitNodeCollectionMixin() {
    }

    public void submitBlock(PoseStack poseStack, BlockState state, int light, int overlay, int outlineColor, BlockAndTintGetter level, BlockPos pos) {
        this.wasUsed = true;
        this.extendedBlockSubmits.add(new ExtendedBlockSubmit(poseStack.last().copy(), state, light, overlay, outlineColor, level, pos));
        Minecraft.getInstance().getModelManager().specialBlockModelRenderer().renderByBlock(state.getBlock(), ItemDisplayContext.NONE, poseStack, (SubmitNodeCollector)this.submitNodeStorage, light, overlay, outlineColor);
    }

    public void submitBlockModel(PoseStack poseStack, Function<ChunkSectionLayer, RenderType> renderTypeFunction, BlockStateModel model, float r, float g, float b, int light, int overlay, int outlineColor, BlockAndTintGetter level, BlockPos pos, BlockState state) {
        this.wasUsed = true;
        this.extendedBlockModelSubmits.add(new ExtendedBlockModelSubmit(poseStack.last().copy(), renderTypeFunction, model, r, g, b, light, overlay, outlineColor, level, pos, state));
    }

    @Override
    public List<ExtendedBlockSubmit> fabric_getExtendedBlockSubmits() {
        return this.extendedBlockSubmits;
    }

    @Override
    public List<ExtendedBlockModelSubmit> fabric_getExtendedBlockModelSubmits() {
        return this.extendedBlockModelSubmits;
    }

    @Inject(method={"clear"}, at={@At(value="RETURN")})
    private void onReturnClear(CallbackInfo ci) {
        this.extendedBlockSubmits.clear();
        this.extendedBlockModelSubmits.clear();
    }
}

