/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client.block.particle;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1058;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_4603;
import net.minecraft.class_773;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_4603.class)
abstract class InGameOverlayRendererMixin {
	@Unique
	@Nullable
	private static class_2338 pos;

	@Redirect(method = "renderOverlays", at = @At(value = "INVOKE", target = "net/minecraft/client/render/block/BlockModels.getModelParticleSprite(Lnet/minecraft/block/BlockState;)Lnet/minecraft/client/texture/Sprite;"))
	private static class_1058 getModelParticleSpriteProxy(class_773 models, class_2680 state, @Local class_1657 playerEntity) {
		if (pos != null) {
			class_1058 sprite = models.getModelParticleSprite(state, playerEntity.method_73183(), pos);
			pos = null;
			return sprite;
		}

		return models.method_3339(state);
	}

	@Inject(method = "getInWallBlockState", at = @At("RETURN"))
	private static void onReturnGetInWallBlockState(CallbackInfoReturnable<@Nullable class_2680> cir, @Local class_2338.class_2339 mutable) {
		if (cir.getReturnValue() != null) {
			pos = mutable.method_10062();
		} else {
			pos = null;
		}
	}
}
