/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.renderer.v1.model;

import java.util.EnumMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadTransform;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.minecraft.class_1058;
import net.minecraft.class_1086;
import net.minecraft.class_2350;
import net.minecraft.class_3665;
import net.minecraft.class_4590;
import net.minecraft.class_4609;
import net.minecraft.class_7837;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public final class ModelBakeSettingsHelper {
    private static final class_2350[] DIRECTIONS = class_2350.values();

    private ModelBakeSettingsHelper() {
    }

    public static class_3665 of(final class_4590 transformation, boolean uvLock) {
        Matrix4fc matrix = transformation.method_22936();
        if (class_7837.method_65174((Matrix4fc)matrix)) {
            return class_1086.field_63619;
        }
        if (!uvLock) {
            return new class_3665(){

                public class_4590 method_3509() {
                    return transformation;
                }
            };
        }
        final EnumMap<class_2350, Matrix4fc> faceTransformations = new EnumMap<class_2350, Matrix4fc>(class_2350.class);
        final EnumMap<class_2350, Matrix4f> inverseFaceTransformations = new EnumMap<class_2350, Matrix4f>(class_2350.class);
        for (class_2350 face : DIRECTIONS) {
            Matrix4fc faceTransformation = class_4609.method_68069((class_4590)transformation, (class_2350)face).method_22936();
            faceTransformations.put(face, faceTransformation);
            inverseFaceTransformations.put(face, faceTransformation.invert(new Matrix4f()));
        }
        return new class_3665(){

            public class_4590 method_3509() {
                return transformation;
            }

            public Matrix4fc method_68011(class_2350 face) {
                return (Matrix4fc)faceTransformations.get(face);
            }

            public Matrix4fc method_68012(class_2350 face) {
                return (Matrix4fc)inverseFaceTransformations.get(face);
            }
        };
    }

    public static class_3665 multiply(class_3665 left, class_3665 right) {
        if (class_7837.method_65174((Matrix4fc)left.method_3509().method_22936())) {
            return right;
        }
        if (class_7837.method_65174((Matrix4fc)right.method_3509().method_22936())) {
            return left;
        }
        final class_4590 transformation = left.method_3509().method_22933(right.method_3509());
        boolean leftHasFaceTransformations = false;
        boolean rightHasFaceTransformations = false;
        for (class_2350 face : DIRECTIONS) {
            if (!leftHasFaceTransformations && !class_7837.method_65174((Matrix4fc)left.method_68011(face))) {
                leftHasFaceTransformations = true;
            }
            if (rightHasFaceTransformations || class_7837.method_65174((Matrix4fc)right.method_68011(face))) continue;
            rightHasFaceTransformations = true;
        }
        if (leftHasFaceTransformations & rightHasFaceTransformations) {
            final EnumMap<class_2350, Matrix4f> faceTransformations = new EnumMap<class_2350, Matrix4f>(class_2350.class);
            final EnumMap<class_2350, Matrix4f> inverseFaceTransformations = new EnumMap<class_2350, Matrix4f>(class_2350.class);
            for (class_2350 face : DIRECTIONS) {
                faceTransformations.put(face, left.method_68011(face).mul(right.method_68011(face), new Matrix4f()));
                inverseFaceTransformations.put(face, right.method_68012(face).mul(left.method_68012(face), new Matrix4f()));
            }
            return new class_3665(){

                public class_4590 method_3509() {
                    return transformation;
                }

                public Matrix4fc method_68011(class_2350 face) {
                    return (Matrix4fc)faceTransformations.get(face);
                }

                public Matrix4fc method_68012(class_2350 face) {
                    return (Matrix4fc)inverseFaceTransformations.get(face);
                }
            };
        }
        final class_3665 faceTransformDelegate = leftHasFaceTransformations ? left : right;
        return new class_3665(){

            public class_4590 method_3509() {
                return transformation;
            }

            public Matrix4fc method_68011(class_2350 face) {
                return faceTransformDelegate.method_68011(face);
            }

            public Matrix4fc method_68012(class_2350 face) {
                return faceTransformDelegate.method_68012(face);
            }
        };
    }

    public static QuadTransform asQuadTransform(class_3665 settings, SpriteFinder spriteFinder) {
        Matrix4fc matrix = settings.method_3509().method_22936();
        if (class_7837.method_65174((Matrix4fc)matrix)) {
            return q -> true;
        }
        Matrix3f normalMatrix = matrix.normal(new Matrix3f());
        Vector4f vec4 = new Vector4f();
        Vector3f vec3 = new Vector3f();
        return quad -> {
            class_2350 lightFace = quad.lightFace();
            Matrix4fc reverseMatrix = settings.method_68012(lightFace);
            if (!class_7837.method_65174((Matrix4fc)reverseMatrix)) {
                class_1058 sprite = spriteFinder.find(quad);
                for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                    float frameU = ModelBakeSettingsHelper.getFrameFromU(sprite, quad.u(vertexIndex));
                    float frameV = ModelBakeSettingsHelper.getFrameFromV(sprite, quad.v(vertexIndex));
                    vec3.set(frameU - 0.5f, frameV - 0.5f, 0.0f);
                    reverseMatrix.transformPosition(vec3);
                    frameU = vec3.x + 0.5f;
                    frameV = vec3.y + 0.5f;
                    quad.uv(vertexIndex, sprite.method_4580(frameU), sprite.method_4570(frameV));
                }
            }
            for (int vertexIndex = 0; vertexIndex < 4; ++vertexIndex) {
                vec4.set(quad.x(vertexIndex) - 0.5f, quad.y(vertexIndex) - 0.5f, quad.z(vertexIndex) - 0.5f, 1.0f);
                vec4.mul(matrix);
                quad.pos(vertexIndex, vec4.x + 0.5f, vec4.y + 0.5f, vec4.z + 0.5f);
                if (!quad.hasNormal(vertexIndex)) continue;
                quad.copyNormal(vertexIndex, vec3);
                vec3.mul((Matrix3fc)normalMatrix);
                vec3.normalize();
                quad.normal(vertexIndex, vec3);
            }
            class_2350 cullFace = quad.cullFace();
            if (cullFace != null) {
                quad.cullFace(class_2350.method_23225((Matrix4fc)matrix, (class_2350)cullFace));
            }
            return true;
        };
    }

    private static float getFrameFromU(class_1058 sprite, float u) {
        float f = sprite.method_4577() - sprite.method_4594();
        return (u - sprite.method_4594()) / f;
    }

    private static float getFrameFromV(class_1058 sprite, float v) {
        float f = sprite.method_4575() - sprite.method_4593();
        return (v - sprite.method_4593()) / f;
    }
}

