/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client.block.model;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_10895;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;

@Mixin(class_10895.class)
abstract class MultipartBlockStateModelMixin implements class_1087 {
	@Shadow
	@Final
	private class_10895.class_1095 bakedModels;

	@Shadow
	@Final
	private class_2680 state;

	@Shadow
	@Nullable
	private List<class_1087> models;

	@Override
	public void emitQuads(QuadEmitter emitter, class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random, Predicate<@Nullable class_2350> cullTest) {
		if (models == null) {
			models = bakedModels.method_68528(this.state);
		}

		long seed = random.method_43055();

		for (class_1087 model : models) {
			random.method_43052(seed);
			model.emitQuads(emitter, blockView, pos, state, random, cullTest);
		}
	}

	@Override
	@Nullable
	public Object createGeometryKey(class_1920 blockView, class_2338 pos, class_2680 state, class_5819 random) {
		if (models == null) {
			models = bakedModels.method_68528(this.state);
		}

		int count = models.size();
		long seed = random.method_43055();

		if (count == 1) {
			random.method_43052(seed);
			return models.getFirst().createGeometryKey(blockView, pos, state, random);
		} else {
			List<Object> subkeys = new ArrayList<>(count);

			for (int i = 0; i < count; i++) {
				random.method_43052(seed);
				Object subkey = models.get(i).createGeometryKey(blockView, pos, state, random);

				if (subkey == null) {
					return null;
				}

				subkeys.add(subkey);
			}

			record Key(List<Object> subkeys) {
			}

			return new Key(subkeys);
		}
	}

	@Override
	public class_1058 particleSprite(class_1920 blockView, class_2338 pos, class_2680 state) {
		return ((MultipartBlockStateModelMultipartBakedModelAccessor) (Object) bakedModels).getSelectors().getFirst().comp_3204().particleSprite(blockView, pos, state);
	}
}
