/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.renderer.client.item;

import com.llamalad7.mixinextras.sugar.Local;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.impl.renderer.BasicItemModelExtension;
import net.minecraft.class_10430;
import net.minecraft.class_10439;
import net.minecraft.class_10442;
import net.minecraft.class_10444;
import net.minecraft.class_11515;
import net.minecraft.class_11566;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_4696;
import net.minecraft.class_4722;
import net.minecraft.class_638;
import net.minecraft.class_811;
import net.minecraft.class_9826;

@Mixin(class_10430.class)
abstract class BlockModelWrapperMixin implements class_10439, BasicItemModelExtension {
	@Shadow
	@Final
	@Mutable
	private boolean animated;

	@Unique
	@Nullable
	private Mesh mesh;

	@Inject(method = "update", at = @At("RETURN"))
	private void onReturnUpdate(final class_10444 output, final class_1799 item, final class_10442 resolver, final class_811 displayContext, final @Nullable class_638 level, final @Nullable class_11566 owner, final int seed, CallbackInfo ci, @Local class_10444.class_10446 layer) {
		if (mesh != null) {
			// This logic matches that of ITEM_RENDER_TYPE_GETTER and BLOCK_RENDER_TYPE_GETTER
			class_11515 defaultSectionLayer;

			if (item.method_7909() instanceof class_1747 blockItem) {
				defaultSectionLayer = class_4696.method_23679(blockItem.method_7711().method_9564());
			} else {
				defaultSectionLayer = class_11515.field_60926;
			}

			layer.setRenderTypeGetter((quadAtlas, sectionLayer) -> {
				return switch (quadAtlas) {
				case BLOCK -> {
					if (sectionLayer == null) {
						sectionLayer = defaultSectionLayer;
					}

					if (sectionLayer != class_11515.field_60926) {
						yield class_4722.method_24074();
					}

					yield class_4722.method_76545();
				}
				case ITEM -> class_4722.method_29382();
				};
			});

			mesh.outputTo(layer.emitter());
		}
	}

	@Override
	public void fabric_setMesh(Mesh mesh, class_9826 spriteGetter) {
		this.mesh = mesh;

		if (!animated) {
			mesh.forEach(quad -> {
				if (animated) {
					return;
				}

				class_10444.class_10445 glint = quad.glint();

				if ((glint != null && glint != class_10444.class_10445.field_55341)
						|| spriteGetter.spriteFinder(quad.atlas().getTextureId()).find(quad).method_45851().method_73020()) {
					animated = true;
				}
			});
		}
	}
}
