/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.renderer.client.item;

import com.llamalad7.mixinextras.sugar.Local;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadAtlas;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.impl.renderer.BasicItemModelExtension;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.resources.model.SpriteGetter;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BlockModelWrapper.class})
abstract class BlockModelWrapperMixin
implements ItemModel,
BasicItemModelExtension {
    @Shadow
    @Final
    @Mutable
    private boolean animated;
    @Unique
    private @Nullable Mesh mesh;

    BlockModelWrapperMixin() {
    }

    @Inject(method={"update"}, at={@At(value="RETURN")})
    private void onReturnUpdate(ItemStackRenderState output, ItemStack item, ItemModelResolver resolver, ItemDisplayContext displayContext, @Nullable ClientLevel level, @Nullable ItemOwner owner, int seed, CallbackInfo ci, @Local ItemStackRenderState.LayerRenderState layer) {
        if (this.mesh != null) {
            ChunkSectionLayer defaultSectionLayer;
            Item item2 = item.getItem();
            if (item2 instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item2;
                defaultSectionLayer = ItemBlockRenderTypes.getChunkRenderType((BlockState)blockItem.getBlock().defaultBlockState());
            } else {
                defaultSectionLayer = ChunkSectionLayer.TRANSLUCENT;
            }
            layer.setRenderTypeGetter((quadAtlas, sectionLayer) -> switch (quadAtlas) {
                default -> throw new MatchException(null, null);
                case QuadAtlas.BLOCK -> {
                    if (sectionLayer == null) {
                        sectionLayer = defaultSectionLayer;
                    }
                    if (sectionLayer != ChunkSectionLayer.TRANSLUCENT) {
                        yield Sheets.cutoutBlockSheet();
                    }
                    yield Sheets.translucentBlockItemSheet();
                }
                case QuadAtlas.ITEM -> Sheets.translucentItemSheet();
            });
            this.mesh.outputTo(layer.emitter());
        }
    }

    @Override
    public void fabric_setMesh(Mesh mesh, SpriteGetter spriteGetter) {
        this.mesh = mesh;
        if (!this.animated) {
            mesh.forEach(quad -> {
                if (this.animated) {
                    return;
                }
                ItemStackRenderState.FoilType glint = quad.glint();
                if (glint != null && glint != ItemStackRenderState.FoilType.NONE || spriteGetter.spriteFinder(quad.atlas().getTextureId()).find((QuadView)quad).contents().isAnimated()) {
                    this.animated = true;
                }
            });
        }
    }
}

