/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.renderer.v1.mesh;

import net.fabricmc.fabric.api.renderer.v1.mesh.QuadAtlas;
import net.fabricmc.fabric.api.renderer.v1.mesh.ShadeMode;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.client.model.geom.builders.UVPair;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.LightCoordsUtil;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public interface QuadView {
    public float x(int var1);

    public float y(int var1);

    public float z(int var1);

    public float posByIndex(int var1, int var2);

    public Vector3f copyPos(int var1, @Nullable Vector3f var2);

    public int color(int var1);

    public float u(int var1);

    public float v(int var1);

    public Vector2f copyUv(int var1, @Nullable Vector2f var2);

    public int lightmap(int var1);

    public boolean hasNormal(int var1);

    public float normalX(int var1);

    public float normalY(int var1);

    public float normalZ(int var1);

    public @Nullable Vector3f copyNormal(int var1, @Nullable Vector3f var2);

    public Vector3fc faceNormal();

    public Direction lightFace();

    public @Nullable Direction nominalFace();

    public @Nullable Direction cullFace();

    public @Nullable ChunkSectionLayer chunkLayer();

    public boolean emissive();

    public boolean diffuseShade();

    public TriState ambientOcclusion();

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable ItemStackRenderState.FoilType foilType();

    public ShadeMode shadeMode();

    public QuadAtlas atlas();

    public int tintIndex();

    public int tag();

    default public BakedQuad toBakedQuad(TextureAtlasSprite sprite) {
        Vector3f position0 = this.copyPos(0, null);
        Vector3f position1 = this.copyPos(1, null);
        Vector3f position2 = this.copyPos(2, null);
        Vector3f position3 = this.copyPos(3, null);
        long packedUV0 = UVPair.pack((float)this.u(0), (float)this.v(0));
        long packedUV1 = UVPair.pack((float)this.u(1), (float)this.v(1));
        long packedUV2 = UVPair.pack((float)this.u(2), (float)this.v(2));
        long packedUV3 = UVPair.pack((float)this.u(3), (float)this.v(3));
        int lightEmission = 15;
        if (!this.emissive()) {
            for (int i = 0; i < 4; ++i) {
                int lightmap = this.lightmap(i);
                if (lightmap == 0) {
                    lightEmission = 0;
                    break;
                }
                int blockLight = LightCoordsUtil.block((int)lightmap);
                int skyLight = LightCoordsUtil.sky((int)lightmap);
                lightEmission = Math.min(lightEmission, Math.min(blockLight, skyLight));
            }
        }
        return new BakedQuad((Vector3fc)position0, (Vector3fc)position1, (Vector3fc)position2, (Vector3fc)position3, packedUV0, packedUV1, packedUV2, packedUV3, this.tintIndex(), this.lightFace(), sprite, this.diffuseShade(), lightEmission);
    }
}

