/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.renderer.v1.render;

import net.fabricmc.fabric.api.renderer.v1.render.BlockMultiBufferSource;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;

public final class ChunkSectionLayerHelper {
    private ChunkSectionLayerHelper() {
    }

    public static RenderType getMovingBlockLayer(ChunkSectionLayer layer) {
        return switch (layer) {
            default -> throw new MatchException(null, null);
            case ChunkSectionLayer.SOLID -> RenderTypes.solidMovingBlock();
            case ChunkSectionLayer.CUTOUT -> RenderTypes.cutoutMovingBlock();
            case ChunkSectionLayer.TRANSLUCENT -> RenderTypes.translucentMovingBlock();
            case ChunkSectionLayer.TRIPWIRE -> RenderTypes.tripwireMovingBlock();
        };
    }

    public static RenderType getEntityBlockLayer(ChunkSectionLayer layer) {
        return layer == ChunkSectionLayer.TRANSLUCENT ? Sheets.translucentBlockItemSheet() : Sheets.cutoutBlockSheet();
    }

    public static BlockMultiBufferSource movingDelegate(MultiBufferSource bufferSource) {
        return layer -> bufferSource.getBuffer(ChunkSectionLayerHelper.getMovingBlockLayer(layer));
    }

    public static BlockMultiBufferSource entityDelegate(MultiBufferSource bufferSource) {
        return layer -> bufferSource.getBuffer(ChunkSectionLayerHelper.getEntityBlockLayer(layer));
    }
}

