/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_4696;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class BlockRenderInfo {
    private final class_324 blockColorMap = class_310.method_1551().method_1505();
    private final class_2338.class_2339 searchPos = new class_2338.class_2339();
    public class_1920 blockView;
    public class_2338 blockPos;
    public class_2680 blockState;
    private boolean useAo;
    private boolean defaultAo;
    private class_11515 defaultLayer;
    private boolean enableCulling;
    private int cullCompletionFlags;
    private int cullResultFlags;

    public void prepareForWorld(class_1920 blockView, boolean enableCulling) {
        this.blockView = blockView;
        this.enableCulling = enableCulling;
    }

    public void prepareForBlock(class_2338 blockPos, class_2680 blockState) {
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.useAo = class_310.method_1588();
        this.defaultAo = this.useAo && blockState.method_26213() == 0;
        this.defaultLayer = class_4696.method_23679((class_2680)blockState);
        this.cullCompletionFlags = 0;
        this.cullResultFlags = 0;
    }

    public void release() {
        this.blockView = null;
        this.blockPos = null;
        this.blockState = null;
    }

    public int blockColor(int tintIndex) {
        return 0xFF000000 | this.blockColorMap.method_1697(this.blockState, this.blockView, this.blockPos, tintIndex);
    }

    public boolean effectiveAo(TriState aoMode) {
        return this.useAo && aoMode.orElse(this.defaultAo);
    }

    public class_11515 effectiveRenderLayer(@Nullable class_11515 quadRenderLayer) {
        return quadRenderLayer == null ? this.defaultLayer : quadRenderLayer;
    }

    public boolean shouldDrawSide(@Nullable class_2350 side) {
        if (side == null || !this.enableCulling) {
            return true;
        }
        int mask = 1 << side.method_10146();
        if ((this.cullCompletionFlags & mask) == 0) {
            this.cullCompletionFlags |= mask;
            if (class_2248.method_9607((class_2680)this.blockState, (class_2680)this.blockView.method_8320((class_2338)this.searchPos.method_25505((class_2382)this.blockPos, side)), (class_2350)side)) {
                this.cullResultFlags |= mask;
                return true;
            }
            return false;
        }
        return (this.cullResultFlags & mask) != 0;
    }

    public boolean shouldCullSide(@Nullable class_2350 side) {
        return !this.shouldDrawSide(side);
    }
}

