/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.Arrays;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderLayerHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.fabricmc.fabric.mixin.client.indigo.renderer.ItemRendererAccessor;
import net.minecraft.class_10444;
import net.minecraft.class_11515;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_777;
import net.minecraft.class_7837;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9848;
import org.joml.Matrix4f;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ItemRenderContext
extends AbstractRenderContext {
    private static final int GLINT_COUNT = class_10444.class_10445.values().length;
    private class_811 displayContext;
    private class_4597 vertexConsumers;
    private int light;
    private int[] tints;
    private class_1921 defaultLayer;
    private class_10444.class_10445 defaultGlint;
    private boolean ignoreQuadGlint;
    private class_4587.class_4665 specialGlintEntry;
    private final class_4588[] vertexConsumerCache = new class_4588[3 * GLINT_COUNT];

    public void renderItem(class_811 displayContext, class_4587 matrixStack, class_4597 vertexConsumers, int light, int overlay, int[] tints, List<class_777> vanillaQuads, MeshView mesh, class_1921 layer, class_10444.class_10445 glint, boolean ignoreQuadGlint) {
        this.displayContext = displayContext;
        this.matrices = matrixStack.method_23760();
        this.vertexConsumers = vertexConsumers;
        this.light = light;
        this.overlay = overlay;
        this.tints = tints;
        this.defaultLayer = layer;
        this.defaultGlint = glint;
        this.ignoreQuadGlint = ignoreQuadGlint;
        this.bufferQuads(vanillaQuads, mesh);
        this.matrices = null;
        this.vertexConsumers = null;
        this.tints = null;
        this.defaultLayer = null;
        this.specialGlintEntry = null;
        Arrays.fill(this.vertexConsumerCache, null);
    }

    private void bufferQuads(List<class_777> vanillaQuads, MeshView mesh) {
        QuadEmitter emitter = this.getEmitter();
        int vanillaQuadCount = vanillaQuads.size();
        for (int i = 0; i < vanillaQuadCount; ++i) {
            class_777 q = vanillaQuads.get(i);
            emitter.fromBakedQuad(q);
            emitter.emit();
        }
        mesh.outputTo(emitter);
    }

    @Override
    protected void bufferQuad(MutableQuadViewImpl quad) {
        class_4588 vertexConsumer = this.getVertexConsumer(quad.renderLayer(), quad.glint());
        this.tintQuad(quad);
        this.shadeQuad(quad, quad.emissive());
        this.bufferQuad(quad, vertexConsumer);
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        int tintIndex = quad.tintIndex();
        if (tintIndex >= 0 && tintIndex < this.tints.length) {
            int tint = this.tints[tintIndex];
            for (int i = 0; i < 4; ++i) {
                quad.color(i, class_9848.method_61322((int)quad.color(i), (int)tint));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int light = this.light;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxLight(quad.lightmap(i), light));
            }
        }
    }

    private class_4588 getVertexConsumer(@Nullable class_11515 quadRenderLayer, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_10444.class_10445 quadGlint) {
        class_1921 layer = quadRenderLayer == null ? this.defaultLayer : RenderLayerHelper.getEntityBlockLayer((class_11515)quadRenderLayer);
        class_10444.class_10445 glint = this.ignoreQuadGlint || quadGlint == null ? this.defaultGlint : quadGlint;
        int cacheIndex = layer == class_4722.method_29382() ? 0 : (layer == class_4722.method_24074() ? GLINT_COUNT : 2 * GLINT_COUNT);
        class_4588 vertexConsumer = this.vertexConsumerCache[cacheIndex += glint.ordinal()];
        if (vertexConsumer == null) {
            this.vertexConsumerCache[cacheIndex] = vertexConsumer = this.createVertexConsumer(layer, glint);
        }
        return vertexConsumer;
    }

    private class_4588 createVertexConsumer(class_1921 layer, class_10444.class_10445 glint) {
        if (glint == class_10444.class_10445.field_55343) {
            if (this.specialGlintEntry == null) {
                this.specialGlintEntry = this.matrices.method_56822();
                if (this.displayContext == class_811.field_4317) {
                    class_7837.method_46414((Matrix4f)this.specialGlintEntry.method_23761(), (float)0.5f);
                } else if (this.displayContext.method_29998()) {
                    class_7837.method_46414((Matrix4f)this.specialGlintEntry.method_23761(), (float)0.75f);
                }
            }
            return ItemRendererAccessor.fabric_getDynamicDisplayGlintConsumer(this.vertexConsumers, layer, this.specialGlintEntry);
        }
        return class_918.method_23181((class_4597)this.vertexConsumers, (class_1921)layer, (boolean)true, (glint != class_10444.class_10445.field_55341 ? 1 : 0) != 0);
    }
}

