/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadAtlas;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.FabricLayerRenderState;
import net.fabricmc.fabric.api.renderer.v1.render.ItemRenderTypeGetter;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.mixin.client.indigo.renderer.ItemRendererAccessor;
import net.minecraft.class_10444;
import net.minecraft.class_11515;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_765;
import net.minecraft.class_777;
import net.minecraft.class_7837;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9848;

/**
 * Used during item buffering to support geometry added through {@link FabricLayerRenderState#emitter()}.
 */
public class ItemRenderContext extends AbstractRenderContext {
	private static final int GLINT_COUNT = class_10444.class_10445.values().length;

	private class_811 displayContext;
	private class_4597 vertexConsumers;
	private int light;
	private int[] tints;

	private class_1921 defaultLayer;
	@Nullable
	private ItemRenderTypeGetter renderTypeGetter;
	private class_10444.class_10445 defaultGlint;
	private boolean ignoreQuadGlint;

	private class_4587.class_4665 specialGlintEntry;
	private final class_4588[] vertexConsumerCache = new class_4588[3 * GLINT_COUNT];

	public void renderItem(
			class_811 displayContext,
			class_4587 matrixStack,
			class_4597 vertexConsumers,
			int light,
			int overlay,
			int[] tints,
			List<class_777> vanillaQuads,
			MeshView mesh,
			class_1921 layer,
			@Nullable ItemRenderTypeGetter renderTypeGetter,
			class_10444.class_10445 glint,
			boolean ignoreQuadGlint
	) {
		this.displayContext = displayContext;
		matrices = matrixStack.method_23760();
		this.vertexConsumers = vertexConsumers;
		this.light = light;
		this.overlay = overlay;
		this.tints = tints;

		defaultLayer = layer;
		this.renderTypeGetter = renderTypeGetter;
		defaultGlint = glint;
		this.ignoreQuadGlint = ignoreQuadGlint;

		bufferQuads(vanillaQuads, mesh);

		matrices = null;
		this.vertexConsumers = null;
		this.tints = null;

		defaultLayer = null;
		this.renderTypeGetter = null;

		specialGlintEntry = null;
		Arrays.fill(vertexConsumerCache, null);
	}

	private void bufferQuads(List<class_777> vanillaQuads, MeshView mesh) {
		QuadEmitter emitter = getEmitter();

		final int vanillaQuadCount = vanillaQuads.size();

		for (int i = 0; i < vanillaQuadCount; i++) {
			final class_777 q = vanillaQuads.get(i);
			emitter.fromBakedQuad(q);
			emitter.emit();
		}

		mesh.outputTo(emitter);
	}

	@Override
	protected void bufferQuad(MutableQuadViewImpl quad) {
		final class_4588 vertexConsumer = getVertexConsumer(quad.atlas(), quad.renderLayer(), quad.glint());

		tintQuad(quad);
		shadeQuad(quad, quad.emissive());
		bufferQuad(quad, vertexConsumer);
	}

	private void tintQuad(MutableQuadViewImpl quad) {
		int tintIndex = quad.tintIndex();

		if (tintIndex >= 0 && tintIndex < tints.length) {
			final int tint = tints[tintIndex];

			for (int i = 0; i < 4; i++) {
				quad.color(i, class_9848.method_61322(quad.color(i), tint));
			}
		}
	}

	private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
		if (emissive) {
			for (int i = 0; i < 4; i++) {
				quad.lightmap(i, class_765.field_32767);
			}
		} else {
			final int light = this.light;

			for (int i = 0; i < 4; i++) {
				quad.lightmap(i, ColorHelper.maxLight(quad.lightmap(i), light));
			}
		}
	}

	private class_4588 getVertexConsumer(QuadAtlas quadAtlas, @Nullable class_11515 quadRenderLayer, class_10444.@Nullable class_10445 quadGlint) {
		class_1921 layer;
		class_10444.class_10445 glint;

		if (renderTypeGetter != null) {
			layer = renderTypeGetter.renderType(quadAtlas, quadRenderLayer);

			if (layer == null) {
				layer = defaultLayer;
			}
		} else {
			layer = defaultLayer;
		}

		if (ignoreQuadGlint || quadGlint == null) {
			glint = defaultGlint;
		} else {
			glint = quadGlint;
		}

		int cacheIndex;

		if (layer == class_4722.method_29382()) {
			cacheIndex = 0;
		} else if (layer == class_4722.method_24074()) {
			cacheIndex = GLINT_COUNT;
		} else if (layer == class_4722.method_76545()) {
			cacheIndex = 2 * GLINT_COUNT;
		} else {
			return createVertexConsumer(layer, glint);
		}

		cacheIndex += glint.ordinal();
		class_4588 vertexConsumer = vertexConsumerCache[cacheIndex];

		if (vertexConsumer == null) {
			vertexConsumer = createVertexConsumer(layer, glint);
			vertexConsumerCache[cacheIndex] = vertexConsumer;
		}

		return vertexConsumer;
	}

	private class_4588 createVertexConsumer(class_1921 layer, class_10444.class_10445 glint) {
		if (glint == class_10444.class_10445.field_55343) {
			if (specialGlintEntry == null) {
				specialGlintEntry = matrices.method_56822();

				if (displayContext == class_811.field_4317) {
					class_7837.method_46414(specialGlintEntry.method_23761(), 0.5F);
				} else if (displayContext.method_29998()) {
					class_7837.method_46414(specialGlintEntry.method_23761(), 0.75F);
				}
			}

			return ItemRendererAccessor.fabric_getDynamicDisplayGlintConsumer(vertexConsumers, layer, specialGlintEntry);
		}

		return class_918.method_23181(vertexConsumers, layer, true, glint != class_10444.class_10445.field_55341);
	}
}
