/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.indigo.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.fabricmc.fabric.impl.client.indigo.renderer.accessor.AccessBatchingRenderCommandQueue;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.ItemRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.MeshItemCommand;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollection;
import net.minecraft.client.renderer.feature.ItemFeatureRenderer;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemFeatureRenderer.class})
abstract class ItemFeatureRendererMixin {
    @Shadow
    @Final
    private PoseStack poseStack;
    @Unique
    private final ItemRenderContext itemRenderContext = new ItemRenderContext();

    ItemFeatureRendererMixin() {
    }

    @Inject(method={"render"}, at={@At(value="RETURN")})
    private void onReturnRender(SubmitNodeCollection queue, MultiBufferSource.BufferSource vertexConsumers, OutlineBufferSource outlineVertexConsumers, CallbackInfo ci) {
        for (MeshItemCommand itemCommand : ((AccessBatchingRenderCommandQueue)queue).fabric_getMeshItemCommands()) {
            this.poseStack.pushPose();
            this.poseStack.last().set(itemCommand.positionMatrix());
            this.itemRenderContext.renderItem(itemCommand.displayContext(), this.poseStack, (MultiBufferSource)vertexConsumers, itemCommand.lightCoords(), itemCommand.overlayCoords(), itemCommand.tintLayers(), itemCommand.quads(), itemCommand.mesh(), itemCommand.renderLayer(), itemCommand.renderTypeGetter(), itemCommand.glintType(), false);
            if (itemCommand.outlineColor() != 0) {
                outlineVertexConsumers.setColor(itemCommand.outlineColor());
                this.itemRenderContext.renderItem(itemCommand.displayContext(), this.poseStack, (MultiBufferSource)outlineVertexConsumers, itemCommand.lightCoords(), itemCommand.overlayCoords(), itemCommand.tintLayers(), itemCommand.quads(), itemCommand.mesh(), itemCommand.renderLayer(), itemCommand.renderTypeGetter(), ItemStackRenderState.FoilType.NONE, true);
            }
            this.poseStack.popPose();
        }
    }
}

