/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.fabricmc.fabric.api.client.renderer.v1.render.BlockMultiBufferSource;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.ColorHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractRenderContext;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public class SimpleBlockRenderContext
extends AbstractRenderContext {
    public static final ThreadLocal<SimpleBlockRenderContext> POOL = ThreadLocal.withInitial(SimpleBlockRenderContext::new);
    private final RandomSource random = RandomSource.createNewThreadLocalInstance();
    private BlockMultiBufferSource bufferSource;
    private ChunkSectionLayer defaultChunkLayer;
    private float red;
    private float green;
    private float blue;
    private int light;
    private @Nullable ChunkSectionLayer lastChunkLayer;
    private @Nullable VertexConsumer lastVertexConsumer;

    @Override
    protected void bufferQuad(MutableQuadViewImpl quad) {
        VertexConsumer vertexConsumer;
        ChunkSectionLayer layer;
        ChunkSectionLayer quadLayer = quad.chunkLayer();
        ChunkSectionLayer chunkSectionLayer = layer = quadLayer == null ? this.defaultChunkLayer : quadLayer;
        if (layer == this.lastChunkLayer) {
            vertexConsumer = this.lastVertexConsumer;
        } else {
            this.lastVertexConsumer = vertexConsumer = this.bufferSource.getBuffer(layer);
            this.lastChunkLayer = layer;
        }
        this.tintQuad(quad);
        this.shadeQuad(quad, quad.emissive());
        this.bufferQuad(quad, vertexConsumer);
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        if (quad.tintIndex() != -1) {
            float red = this.red;
            float green = this.green;
            float blue = this.blue;
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ARGB.scaleRGB((int)quad.color(i), (float)red, (float)green, (float)blue));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int light = this.light;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxLight(quad.lightmap(i), light));
            }
        }
    }

    public void bufferModel(PoseStack.Pose pose, BlockMultiBufferSource bufferSource, BlockStateModel model, float red, float green, float blue, int light, int overlay, BlockAndTintGetter level, BlockPos pos, BlockState state) {
        this.pose = pose;
        this.overlay = overlay;
        this.bufferSource = bufferSource;
        this.defaultChunkLayer = ItemBlockRenderTypes.getChunkRenderType((BlockState)state);
        this.red = Mth.clamp((float)red, (float)0.0f, (float)1.0f);
        this.green = Mth.clamp((float)green, (float)0.0f, (float)1.0f);
        this.blue = Mth.clamp((float)blue, (float)0.0f, (float)1.0f);
        this.light = light;
        this.random.setSeed(42L);
        model.emitQuads(this.getEmitter(), level, pos, state, this.random, direction -> false);
        this.pose = null;
        this.bufferSource = null;
        this.lastChunkLayer = null;
        this.lastVertexConsumer = null;
    }
}

