/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import net.fabricmc.fabric.api.client.renderer.v1.render.BlockMultiBufferSource;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractTerrainRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.LightDataProvider;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TerrainLikeRenderContext
extends AbstractTerrainRenderContext {
    public static final ThreadLocal<TerrainLikeRenderContext> POOL = ThreadLocal.withInitial(TerrainLikeRenderContext::new);
    private final RandomSource random = RandomSource.createNewThreadLocalInstance();
    private BlockMultiBufferSource bufferSource;

    @Override
    protected LightDataProvider createLightDataProvider(final BlockRenderInfo blockInfo) {
        return new LightDataProvider(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int light(BlockPos pos, BlockState state) {
                return LevelRenderer.getLightCoords((LevelRenderer.BrightnessGetter)LevelRenderer.BrightnessGetter.DEFAULT, (BlockAndTintGetter)blockInfo.level, (BlockState)state, (BlockPos)pos);
            }

            @Override
            public float ao(BlockPos pos, BlockState state) {
                return AoLuminanceFix.INSTANCE.apply((BlockGetter)blockInfo.level, pos, state);
            }
        };
    }

    @Override
    protected VertexConsumer getVertexConsumer(ChunkSectionLayer layer) {
        return this.bufferSource.getBuffer(layer);
    }

    public void bufferModel(BlockAndTintGetter level, BlockStateModel model, BlockState state, BlockPos pos, PoseStack poseStack, BlockMultiBufferSource bufferSource, boolean cull, long seed, int overlay) {
        try {
            Vec3 offset = state.getOffset(pos);
            poseStack.translate(offset.x, offset.y, offset.z);
            this.pose = poseStack.last();
            this.overlay = overlay;
            this.bufferSource = bufferSource;
            this.blockInfo.prepareForLevel(level, cull);
            this.random.setSeed(seed);
            this.prepare(pos, state);
            model.emitQuads(this.getEmitter(), level, pos, state, this.random, this.blockInfo::shouldCullSide);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)throwable, (String)"Tessellating block model - Indigo Renderer");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Block model being tessellated");
            CrashReportCategory.populateBlockDetails((CrashReportCategory)crashReportCategory, (LevelHeightAccessor)level, (BlockPos)pos, (BlockState)state);
            throw new ReportedException(crashReport);
        }
        finally {
            this.blockInfo.release();
            this.pose = null;
            this.bufferSource = null;
        }
    }
}

