/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Arrays;
import java.util.function.Function;
import net.fabricmc.fabric.impl.client.indigo.renderer.aocalc.AoLuminanceFix;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.AbstractTerrainRenderContext;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.LightDataProvider;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TerrainRenderContext
extends AbstractTerrainRenderContext {
    public static final ThreadLocal<TerrainRenderContext> POOL = ThreadLocal.withInitial(TerrainRenderContext::new);
    private PoseStack poseStack;
    private RandomSource random;
    private Function<ChunkSectionLayer, BufferBuilder> bufferFunc;

    public TerrainRenderContext() {
        this.overlay = OverlayTexture.NO_OVERLAY;
    }

    @Override
    protected LightDataProvider createLightDataProvider(BlockRenderInfo blockInfo) {
        return new LightDataCache(blockInfo);
    }

    @Override
    protected VertexConsumer getVertexConsumer(ChunkSectionLayer layer) {
        return (VertexConsumer)this.bufferFunc.apply(layer);
    }

    public void prepare(BlockAndTintGetter level, BlockPos sectionOrigin, PoseStack poseStack, RandomSource random, Function<ChunkSectionLayer, BufferBuilder> bufferFunc) {
        this.blockInfo.prepareForLevel(level, true);
        ((LightDataCache)this.lightDataProvider).prepare(sectionOrigin);
        this.poseStack = poseStack;
        this.random = random;
        this.bufferFunc = bufferFunc;
    }

    public void release() {
        this.pose = null;
        this.poseStack = null;
        this.random = null;
        this.bufferFunc = null;
        this.blockInfo.release();
    }

    public void bufferModel(BlockStateModel model, BlockState blockState, BlockPos blockPos) {
        this.poseStack.pushPose();
        try {
            this.poseStack.translate((float)SectionPos.sectionRelative((int)blockPos.getX()), (float)SectionPos.sectionRelative((int)blockPos.getY()), (float)SectionPos.sectionRelative((int)blockPos.getZ()));
            Vec3 offset = blockState.getOffset(blockPos);
            this.poseStack.translate(offset.x, offset.y, offset.z);
            this.pose = this.poseStack.last();
            this.random.setSeed(blockState.getSeed(blockPos));
            this.prepare(blockPos, blockState);
            model.emitQuads(this.getEmitter(), this.blockInfo.level, blockPos, blockState, this.random, this.blockInfo::shouldCullSide);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.forThrowable((Throwable)throwable, (String)"Tessellating block in world - Indigo Renderer");
            CrashReportCategory crashReportCategory = crashReport.addCategory("Block being tessellated");
            CrashReportCategory.populateBlockDetails((CrashReportCategory)crashReportCategory, (LevelHeightAccessor)this.blockInfo.level, (BlockPos)blockPos, (BlockState)blockState);
            throw new ReportedException(crashReport);
        }
        finally {
            this.poseStack.popPose();
        }
    }

    private static class LightDataCache
    implements LightDataProvider {
        private final int[] lightCache = new int[5832];
        private final float[] aoCache = new float[5832];
        private final BlockRenderInfo blockInfo;
        private BlockPos sectionOrigin;
        private final LevelRenderer.BrightnessGetter brightnessGetter = (level, pos) -> {
            int cacheIndex = this.cacheIndex(pos);
            if (cacheIndex == -1) {
                return LevelRenderer.BrightnessGetter.DEFAULT.packedBrightness(level, pos);
            }
            int result = this.lightCache[cacheIndex];
            if (result == Integer.MAX_VALUE) {
                this.lightCache[cacheIndex] = result = LevelRenderer.BrightnessGetter.DEFAULT.packedBrightness(level, pos);
            }
            return result;
        };

        LightDataCache(BlockRenderInfo blockInfo) {
            this.blockInfo = blockInfo;
        }

        public void prepare(BlockPos sectionOrigin) {
            this.sectionOrigin = sectionOrigin;
            Arrays.fill(this.lightCache, Integer.MAX_VALUE);
            Arrays.fill(this.aoCache, Float.NaN);
        }

        @Override
        public int light(BlockPos pos, BlockState state) {
            return LevelRenderer.getLightCoords((LevelRenderer.BrightnessGetter)this.brightnessGetter, (BlockAndTintGetter)this.blockInfo.level, (BlockState)state, (BlockPos)pos);
        }

        @Override
        public float ao(BlockPos pos, BlockState state) {
            int cacheIndex = this.cacheIndex(pos);
            if (cacheIndex == -1) {
                return AoLuminanceFix.INSTANCE.apply((BlockGetter)this.blockInfo.level, pos, state);
            }
            float result = this.aoCache[cacheIndex];
            if (Float.isNaN(result)) {
                this.aoCache[cacheIndex] = result = AoLuminanceFix.INSTANCE.apply((BlockGetter)this.blockInfo.level, pos, state);
            }
            return result;
        }

        private int cacheIndex(BlockPos pos) {
            int localX = pos.getX() - (this.sectionOrigin.getX() - 1);
            if (localX < 0 || localX >= 18) {
                return -1;
            }
            int localY = pos.getY() - (this.sectionOrigin.getY() - 1);
            if (localY < 0 || localY >= 18) {
                return -1;
            }
            int localZ = pos.getZ() - (this.sectionOrigin.getZ() - 1);
            if (localZ < 0 || localZ >= 18) {
                return -1;
            }
            return localZ * 18 * 18 + localY * 18 + localX;
        }
    }
}

