/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.mixin.client.indigo.renderer;

import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.Map;
import net.fabricmc.fabric.impl.client.indigo.renderer.accessor.AccessRenderSectionRegion;
import net.fabricmc.fabric.impl.client.indigo.renderer.render.TerrainRenderContext;
import net.minecraft.client.renderer.SectionBufferBuilderPack;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.chunk.RenderSectionRegion;
import net.minecraft.client.renderer.chunk.SectionCompiler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SectionCompiler.class})
abstract class SectionCompilerMixin {
    @Shadow
    @Final
    private BlockRenderDispatcher blockRenderer;

    SectionCompilerMixin() {
    }

    @Shadow
    protected abstract BufferBuilder getOrBeginLayer(Map<ChunkSectionLayer, BufferBuilder> var1, SectionBufferBuilderPack var2, ChunkSectionLayer var3);

    @Inject(method={"compile"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;betweenClosed(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Ljava/lang/Iterable;")})
    private void hookBuild(SectionPos sectionPos, RenderSectionRegion region, VertexSorting sorter, SectionBufferBuilderPack buffers, CallbackInfoReturnable<SectionCompiler.Results> cir, @Local(ordinal=0) BlockPos sectionOrigin, @Local(ordinal=0) PoseStack poseStack, @Local(ordinal=0) Map<ChunkSectionLayer, BufferBuilder> builderMap, @Local(ordinal=0) RandomSource random) {
        TerrainRenderContext renderer = TerrainRenderContext.POOL.get();
        renderer.prepare((BlockAndTintGetter)region, sectionOrigin, poseStack, random, layer -> this.getOrBeginLayer(builderMap, buffers, (ChunkSectionLayer)layer));
        ((AccessRenderSectionRegion)region).fabric_setRenderer(renderer);
    }

    @Redirect(method={"compile"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getRenderShape()Lnet/minecraft/world/level/block/RenderShape;"))
    private RenderShape hookBuildRenderBlock(BlockState blockState, SectionPos sectionPos, RenderSectionRegion renderRegion, VertexSorting vertexSorter, SectionBufferBuilderPack buffers, @Local(ordinal=2) BlockPos blockPos) {
        RenderShape renderShape = blockState.getRenderShape();
        if (renderShape == RenderShape.MODEL) {
            BlockStateModel model = this.blockRenderer.getBlockModel(blockState);
            ((AccessRenderSectionRegion)renderRegion).fabric_getRenderer().bufferModel(model, blockState, blockPos);
            return RenderShape.INVISIBLE;
        }
        return renderShape;
    }

    @Inject(method={"compile"}, at={@At(value="RETURN")})
    private void hookBuildReturn(SectionPos sectionPos, RenderSectionRegion renderRegion, VertexSorting vertexSorter, SectionBufferBuilderPack buffers, CallbackInfoReturnable<SectionCompiler.Results> cir) {
        ((AccessRenderSectionRegion)renderRegion).fabric_getRenderer().release();
        ((AccessRenderSectionRegion)renderRegion).fabric_setRenderer(null);
    }
}

