/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.renderer.registry;

import java.util.Map;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_3296;
import net.minecraft.class_897;
import net.minecraft.class_898;
import net.minecraft.class_918;

@Mixin(class_898.class)
public class MixinEntityRenderDispatcher {
	@Shadow
	Map<class_1299<?>, class_897<?>> renderers;

	@Inject(method = "registerRenderers", at = @At(value = "RETURN"), require = 1)
	public void on_method_23167(class_918 itemRenderer, class_3296 manager, CallbackInfo info) {
		final class_898 me = (class_898) (Object) this;
		EntityRendererRegistry.INSTANCE.initialize(me, me.field_4685, manager, itemRenderer, renderers);
	}
}
