/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.rendering.fluid;

import java.util.IdentityHashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1163;
import net.minecraft.class_1723;
import net.minecraft.class_1920;
import net.minecraft.class_1972;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2373;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4588;
import net.minecraft.class_5458;
import net.minecraft.class_775;

public class FluidRenderHandlerRegistryImpl implements FluidRenderHandlerRegistry {
	private static final int DEFAULT_WATER_COLOR = class_5458.field_25933.method_29107(class_1972.field_9423).method_8687();
	private final Map<class_3611, FluidRenderHandler> handlers = new IdentityHashMap<>();
	private final Map<class_3611, FluidRenderHandler> modHandlers = new IdentityHashMap<>();
	private final Map<class_2248, Boolean> overlayBlocks = new IdentityHashMap<>();

	private class_775 fluidRenderer;

	public FluidRenderHandlerRegistryImpl() {
	}

	@Override
	public FluidRenderHandler get(class_3611 fluid) {
		return handlers.get(fluid);
	}

	public FluidRenderHandler getOverride(class_3611 fluid) {
		return modHandlers.get(fluid);
	}

	@Override
	public void register(class_3611 fluid, FluidRenderHandler renderer) {
		handlers.put(fluid, renderer);
		modHandlers.put(fluid, renderer);
	}

	@Override
	public void setBlockTransparency(class_2248 block, boolean transparent) {
		overlayBlocks.put(block, transparent);
	}

	@Override
	public boolean isBlockTransparent(class_2248 block) {
		return overlayBlocks.computeIfAbsent(block, k -> k instanceof class_2373 || k instanceof class_2397);
	}

	public void onFluidRendererReload(class_775 renderer, class_1058[] waterSprites, class_1058[] lavaSprites, class_1058 waterOverlay) {
		fluidRenderer = renderer;

		class_1058[] waterSpritesFull = {waterSprites[0], waterSprites[1], waterOverlay};
		FluidRenderHandler waterHandler = new FluidRenderHandler() {
			@Override
			public class_1058[] getFluidSprites(class_1920 view, class_2338 pos, class_3610 state) {
				return waterSpritesFull;
			}

			@Override
			public int getFluidColor(class_1920 view, class_2338 pos, class_3610 state) {
				if (view != null && pos != null) {
					return class_1163.method_4961(view, pos);
				} else {
					return DEFAULT_WATER_COLOR;
				}
			}
		};

		//noinspection Convert2Lambda
		FluidRenderHandler lavaHandler = new FluidRenderHandler() {
			@Override
			public class_1058[] getFluidSprites(class_1920 view, class_2338 pos, class_3610 state) {
				return lavaSprites;
			}
		};

		register(class_3612.field_15910, waterHandler);
		register(class_3612.field_15909, waterHandler);
		register(class_3612.field_15908, lavaHandler);
		register(class_3612.field_15907, lavaHandler);
		handlers.putAll(modHandlers);

		class_1059 texture = class_310.method_1551()
				.method_1554()
				.method_24153(class_1723.field_21668);

		for (FluidRenderHandler handler : handlers.values()) {
			handler.reloadTextures(texture);
		}
	}

	public void renderFluid(class_2338 pos, class_1920 world, class_4588 vertexConsumer, class_2680 blockState, class_3610 fluidState) {
		fluidRenderer.method_3347(world, pos, vertexConsumer, blockState, fluidState);
	}
}
