/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.impl.client.rendering.fluid;

import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3610;

public class FluidRendererHookContainer {
	public class_1920 view;
	public class_2338 pos;
	public class_2680 blockState;
	public class_3610 fluidState;
	public FluidRenderHandler handler;
	public final class_1058[] sprites = new class_1058[2];
	public class_1058 overlay;
	public boolean hasOverlay;

	public void getSprites(class_1920 world, class_2338 pos, class_3610 fluidState) {
		if (handler != null) {
			class_1058[] sprites = handler.getFluidSprites(world, pos, fluidState);

			this.sprites[0] = sprites[0];
			this.sprites[1] = sprites[1];

			if (sprites.length > 2) {
				hasOverlay = true;
				overlay = sprites[2];
			}
		} else {
			hasOverlay = false;
		}
	}

	public void clear() {
		view = null;
		pos = null;
		blockState = null;
		fluidState = null;
		handler = null;
		sprites[0] = null;
		sprites[1] = null;
		overlay = null;
		hasOverlay = false;
	}
}
