/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.api.client.render.fluid.v1;

import java.util.Objects;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.Identifier;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import org.jspecify.annotations.Nullable;

public class SimpleFluidRenderHandler
implements FluidRenderHandler {
    public static final Identifier WATER_STILL = Identifier.withDefaultNamespace((String)"block/water_still");
    public static final Identifier WATER_FLOWING = Identifier.withDefaultNamespace((String)"block/water_flow");
    public static final Identifier WATER_OVERLAY = Identifier.withDefaultNamespace((String)"block/water_overlay");
    public static final Identifier LAVA_STILL = Identifier.withDefaultNamespace((String)"block/lava_still");
    public static final Identifier LAVA_FLOWING = Identifier.withDefaultNamespace((String)"block/lava_flow");
    protected final Identifier stillTexture;
    protected final Identifier flowingTexture;
    protected final Identifier overlayTexture;
    protected final TextureAtlasSprite[] sprites;
    protected final int tint;

    public SimpleFluidRenderHandler(Identifier stillTexture, Identifier flowingTexture, @Nullable Identifier overlayTexture, int tint) {
        this.stillTexture = Objects.requireNonNull(stillTexture, "stillTexture");
        this.flowingTexture = Objects.requireNonNull(flowingTexture, "flowingTexture");
        this.overlayTexture = overlayTexture;
        this.sprites = new TextureAtlasSprite[overlayTexture == null ? 2 : 3];
        this.tint = tint;
    }

    public SimpleFluidRenderHandler(Identifier stillTexture, Identifier flowingTexture, Identifier overlayTexture) {
        this(stillTexture, flowingTexture, overlayTexture, -1);
    }

    public SimpleFluidRenderHandler(Identifier stillTexture, Identifier flowingTexture, int tint) {
        this(stillTexture, flowingTexture, null, tint);
    }

    public SimpleFluidRenderHandler(Identifier stillTexture, Identifier flowingTexture) {
        this(stillTexture, flowingTexture, null, -1);
    }

    public static SimpleFluidRenderHandler coloredWater(int tint) {
        return new SimpleFluidRenderHandler(WATER_STILL, WATER_FLOWING, WATER_OVERLAY, tint);
    }

    @Override
    public TextureAtlasSprite[] getFluidSprites(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, FluidState state) {
        return this.sprites;
    }

    @Override
    public void reloadTextures(TextureAtlas textureAtlas) {
        this.sprites[0] = textureAtlas.getSprite(this.stillTexture);
        this.sprites[1] = textureAtlas.getSprite(this.flowingTexture);
        if (this.overlayTexture != null) {
            this.sprites[2] = textureAtlas.getSprite(this.overlayTexture);
        }
    }

    @Override
    public int getFluidColor(@Nullable BlockAndTintGetter view, @Nullable BlockPos pos, FluidState state) {
        return this.tint;
    }
}

