/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.rendering.fluid;

import com.llamalad7.mixinextras.expression.Definition;
import com.llamalad7.mixinextras.expression.Expression;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandler;
import net.fabricmc.fabric.api.client.render.fluid.v1.FluidRenderHandlerRegistry;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderHandlerInfo;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderHandlerRegistryImpl;
import net.fabricmc.fabric.impl.client.rendering.fluid.FluidRenderingImpl;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_4588;
import net.minecraft.class_775;

@Mixin(class_775.class)
public class LiquidBlockRendererMixin {
	@Shadow
	@Final
	private class_1058 waterOverlay;

	@Shadow
	@Final
	private class_1058 waterStill;

	@Shadow
	@Final
	private class_1058 waterFlowing;

	@Shadow
	@Final
	private class_1058 lavaStill;

	@Shadow
	@Final
	private class_1058 lavaFlowing;

	@Inject(method = "<init>", at = @At("RETURN"))
	public void onResourceReloadReturn(CallbackInfo info) {
		class_775 self = (class_775) (Object) this;
		((FluidRenderHandlerRegistryImpl) FluidRenderHandlerRegistry.INSTANCE).onFluidRendererReload(self, new class_1058[]{waterStill, waterFlowing, waterOverlay}, new class_1058[]{lavaStill, lavaFlowing}, waterOverlay);
	}

	@Inject(method = "tesselate", at = @At("HEAD"), cancellable = true)
	public void onHeadRender(class_1920 view, class_2338 pos, class_4588 vertexConsumer, class_2680 blockState, class_3610 fluidState, CallbackInfo ci) {
		FluidRenderHandlerInfo info = FluidRenderingImpl.getCurrentInfo();

		if (info.handler == null) {
			FluidRenderHandler handler = FluidRenderHandlerRegistry.INSTANCE.get(fluidState.method_15772());

			if (handler != null) {
				handler.renderFluid(pos, view, vertexConsumer, blockState, fluidState);
				ci.cancel();
			}
		}
	}

	@Unique
	private class_1058 getOrDefault(int index, class_1058 original) {
		FluidRenderHandlerInfo info = FluidRenderingImpl.getCurrentInfo();

		if (info.handler == null) {
			return original;
		}

		if (info.sprites.length == index - 1) {
			return original;
		}

		return info.sprites[index];
	}

	@ModifyVariable(
			method = "tesselate",
			at = @At("STORE"),
			ordinal = 0
	)
	public class_1058 modStill(class_1058 original) {
		return getOrDefault(0, original);
	}

	@ModifyVariable(
			method = "tesselate",
			at = @At("STORE"),
			ordinal = 1
	)
	public class_1058 modFlowing(class_1058 original) {
		return getOrDefault(1, original);
	}

	@ModifyExpressionValue(
			method = "tesselate",
			at = {
					@At(value = "CONSTANT", args = "intValue=" + 0xffffff),
					@At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/BiomeColors;getAverageWaterColor(Lnet/minecraft/world/level/BlockAndTintGetter;Lnet/minecraft/core/BlockPos;)I")
			}
	)
	public int modTintColor(int original, class_1920 world, class_2338 pos, class_4588 vertexConsumer, class_2680 blockState, class_3610 fluidState) {
		FluidRenderHandlerInfo info = FluidRenderingImpl.getCurrentInfo();
		return info.handler != null ? info.handler.getFluidColor(world, pos, fluidState) : original;
	}

	@Definition(id = "getU", method = "Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;getU(F)F")
	@Definition(id = "sprite2", local = @Local(type = class_1058.class, ordinal = 2))
	@Expression("@(sprite2).getU(0.0)")
	@ModifyVariable(
			method = "tesselate",
			at = @At(value = "MIXINEXTRAS:EXPRESSION", ordinal = 0),
			slice = @Slice(from = @At(value = "FIELD", target = "Lnet/minecraft/client/renderer/block/LiquidBlockRenderer;waterOverlay:Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;")),
			ordinal = 2
	)
	private class_1058 modifyOverlaySprite(
			class_1058 waterOverlay,
			class_1920 world,
			@Local(ordinal = 1) class_2338 neighborPos,
			@Local(ordinal = 0) boolean isLava,
			@Local(ordinal = 1) class_1058 flowingSprite,
			@Share("useOverlay") LocalBooleanRef useOverlay
	) {
		final FluidRenderHandlerInfo info = FluidRenderingImpl.getCurrentInfo();
		boolean hasOverlay = info.handler != null ? info.hasOverlay : !isLava;

		class_2248 neighborBlock = world.method_8320(neighborPos).method_26204();
		useOverlay.set(hasOverlay && FluidRenderHandlerRegistry.INSTANCE.isBlockTransparent(neighborBlock));

		if (useOverlay.get()) {
			return info.handler != null ? info.overlaySprite : this.waterOverlay;
		} else {
			return flowingSprite;
		}
	}

	@Definition(id = "sprite2", local = @Local(type = class_1058.class, ordinal = 2))
	@Definition(id = "waterOverlaySprite", field = "Lnet/minecraft/client/renderer/block/LiquidBlockRenderer;waterOverlay:Lnet/minecraft/client/renderer/texture/TextureAtlasSprite;")
	@Expression("sprite2 != this.waterOverlaySprite")
	@ModifyExpressionValue(method = "tesselate", at = @At("MIXINEXTRAS:EXPRESSION"))
	private boolean modifyNonOverlayCheck(boolean original, @Share("useOverlay") LocalBooleanRef useOverlay) {
		return !useOverlay.get();
	}
}
