/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.rendering;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1163;
import net.minecraft.class_4700;
import net.minecraft.class_6539;
import org.jetbrains.annotations.UnmodifiableView;

@Environment(value=EnvType.CLIENT)
public final class ColorResolverRegistryImpl {
    private static final Set<class_6539> ALL_RESOLVERS = new HashSet<class_6539>();
    private static final Set<class_6539> CUSTOM_RESOLVERS = new HashSet<class_6539>();
    private static final Set<class_6539> ALL_RESOLVERS_VIEW = Collections.unmodifiableSet(ALL_RESOLVERS);
    private static final Set<class_6539> CUSTOM_RESOLVERS_VIEW = Collections.unmodifiableSet(CUSTOM_RESOLVERS);

    private ColorResolverRegistryImpl() {
    }

    public static void register(class_6539 resolver) {
        ALL_RESOLVERS.add(resolver);
        CUSTOM_RESOLVERS.add(resolver);
    }

    public static @UnmodifiableView Set<class_6539> getAllResolvers() {
        return ALL_RESOLVERS_VIEW;
    }

    public static @UnmodifiableView Set<class_6539> getCustomResolvers() {
        return CUSTOM_RESOLVERS_VIEW;
    }

    public static Reference2ReferenceMap<class_6539, class_4700> createCustomCacheMap(Function<class_6539, class_4700> cacheFactory) {
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        for (class_6539 resolver : CUSTOM_RESOLVERS) {
            map.put((Object)resolver, (Object)cacheFactory.apply(resolver));
        }
        map.trim();
        return map;
    }

    static {
        ALL_RESOLVERS.add(class_1163.field_5665);
        ALL_RESOLVERS.add(class_1163.field_5664);
        ALL_RESOLVERS.add(class_1163.field_5666);
    }
}

